% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_modeling.R
\name{model_topics}
\alias{model_topics}
\title{Analyze topics in Goodreads reviews}
\usage{
model_topics(reviews, num_topics = 3, num_terms = 10, english_only = TRUE)
}
\arguments{
\item{reviews}{A data frame containing the scraped reviews}

\item{num_topics}{The number of topics to extract}

\item{num_terms}{The number of top terms to display for each topic}

\item{english_only}{A logical value indicating whether to filter out non-English reviews. Default is FALSE.}
}
\value{
A list containing the following elements:
\itemize{
\item \code{model}: The fitted LDA model object.
\item \code{filtered_reviews}: The preprocessed and filtered reviews data frame.
}
}
\description{
This function takes the output from scrape_reviews, preprocesses the data,
performs topic modeling, and prints the results.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)

# Scrape reviews
reviews <- scrape_reviews(temp_file, num_reviews = 5, use_parallel = FALSE)

# Model topics
topic_results <- model_topics(reviews, num_topics = 2, num_terms = 5, english_only = TRUE)

# Print model summary
print(topic_results$model)

# Clean up: remove the temporary file
file.remove(temp_file)
}
}
