% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_modeling.R
\name{top_terms}
\alias{top_terms}
\title{Extract and print top terms for each topic}
\usage{
top_terms(lda_model, n = 10, verbose = TRUE)
}
\arguments{
\item{lda_model}{An LDA model}

\item{n}{The number of top terms to extract for each topic}

\item{verbose}{Logical; if TRUE, print the top terms to the console (default is TRUE)}
}
\value{
A list of character vectors, each containing the top terms for a topic.
}
\description{
This function extracts the top terms for each topic in the LDA model and optionally prints them.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)

# Scrape reviews
reviews <- scrape_reviews(temp_file, num_reviews = 5, use_parallel = FALSE)

# Preprocess the reviews
preprocessed <- preprocess_reviews(reviews, english_only = TRUE)

# Fit LDA model
lda_model <- fit_lda(preprocessed$dtm, k = 2)

# Print top terms
top_terms(lda_model, n = 5)

# Clean up: remove the temporary file
file.remove(temp_file)
}
}
