% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_modeling.R
\name{fit_lda}
\alias{fit_lda}
\title{Perform topic modeling on preprocessed reviews}
\usage{
fit_lda(dtm, k, method = "Gibbs")
}
\arguments{
\item{dtm}{A document-term matrix}

\item{k}{The number of topics to extract}

\item{method}{The method to use for fitting the model (default: Gibbs)}
}
\value{
An LDA model
}
\description{
This function performs LDA topic modeling on the preprocessed reviews.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)

# Scrape reviews
reviews <- scrape_reviews(temp_file, num_reviews = 5, use_parallel = FALSE)

# Preprocess the reviews
preprocessed <- preprocess_reviews(reviews, english_only = TRUE)

# Fit LDA model
lda_model <- fit_lda(preprocessed$dtm, k = 2)

# Print model summary
print(lda_model)

# Clean up: remove the temporary file
file.remove(temp_file)
}
}
