\name{fiber.angle}
\alias{fiber.angle}
\title{
\strong{Experimental!} Calculating the orientation of muscle fibers}
\description{
Calculating the angle of individual muscle fibers. Currently this function can only calculate fiber angles around a central axis (x, y or z). Fiber data is centered around the other axes.

Will eventually include an option for a tendon image stack. Not yet complete}
\usage{
fiber.angle(fib.list, axis, centered = TRUE)
}
\arguments{
  \item{fib.list}{
A list of muscle fiber paths generated by good.fibes or from the various cleaning and processing function (must contain $fiber.points).}
  \item{axis}{
The axis around which angles will be calculated as a deviation from 
}
  \item{centered}{
Should the data be centered on the other two axes before calculation.}
}
\value{
A vector of angles in degrees corresponding to each fiber in the original list}
\references{
Arbour, J. In Prep. GoodFibes: an R package for the detection of muscle fibers from diceCT scans.

Katzke, J., Puchenkov, P., Stark, H., and Economo, E. 2022. A Roadmap to Reconstructing Muscle Architecture from CT Data. \emph{Integrative Organismal Biology} 4(1): 1-16.

Sullivan, S., McGechie, F., Middleton, K., and Holliday, C. 3D Muscle Architecture of the Pectoral Muscles of European Starling (Sturnus vulgaris).\emph{Integrative Organismal Biology} 1(1):1-18.

}
\author{
J. Arbour
}
\note{
\strong{NOT TOTALLY VERIFIED YET, USE WITH CAUTION}
}
\seealso{
\code{\link{fiber.lengths}}
}
\examples{

\donttest{
olddir<-getwd()

data(ant.final)
fangle<-fiber.angle(ant.final,3)
fangle

cols<-color.scale(fangle, "blue", "red")
muscle.plot.stl(ant.final, cols=cols, df = 1)

setwd(olddir)
}
}
