library(grid)
grid.newpage()

# Initiate the boxes that we want to connect
start <- boxGrob("Top", x=.5, y=.8)
end <- boxGrob("Bottom", x=.5, y=.2)
side <- boxPropGrob("Side", "Left", "Right", prop=.3, x=.2, y=.8)
sub_side_left <- boxGrob("Left", x = attr(side, "coords")$left_x, y = .5)
sub_side_right <- boxGrob("Right", x = attr(side, "coords")$right_x, y = .5)
exclude <- boxGrob("Exclude:\n - Too sick\n - Prev. surgery", x=.8, y=.5,just="left")

# Connect the boxes and print/plot them
connectGrob(start, end, "vertical")
connectGrob(start, side, "horizontal")
connectGrob(side, sub_side_left, "v", "l")
connectGrob(side, sub_side_right, "v", "r")
connectGrob(start, exclude, "L")

# Print the grobs
start
end
side
exclude
sub_side_left
sub_side_right
