% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lda.R
\name{germaparl_download_lda}
\alias{germaparl_download_lda}
\alias{topics}
\alias{germaparl_load_lda}
\title{Use topicmodels prepared for GermaParl.}
\usage{
germaparl_download_lda(
  k = c(100L, 150L, 175L, 200L, 225L, 250L, 275L, 300L, 350L, 400L, 450L),
  doi = "10.5281/zenodo.3742113",
  data_dir,
  sample = FALSE
)

germaparl_load_lda(
  k,
  registry_dir = cwbtools::cwb_registry_dir(),
  verbose = TRUE,
  sample = FALSE
)
}
\arguments{
\item{k}{A \code{numeric} or \code{integer} vector, the number of topics of
the topicmodel. Multiple values can be provided to download several topic
models at once.}

\item{doi}{The DOI of GermaParl at Zenodo.}

\item{data_dir}{The data directory with the binary files of the GERMAPARL
corpus. If missing, the directory will be guessed using the function
\code{cwb::cwb_corpus_dir}}

\item{sample}{A \code{logical} value, if \code{TRUE}, use GERMAPARLSAMPLE
corpus rather than GERMAPARL.}

\item{registry_dir}{The registry directory where the registry file for GERMAPARL
is located.}

\item{verbose}{logical}
}
\value{
The functions \code{germaparl_download_lda} and
  \code{germaparl_encode_lda_topics} are returned for their side effects
  (downloading topic model and encoding topic model). They return \code{TRUE}
  if the operation has been succesful. The \code{germaparl_download_lda}
  function will return a \code{LDA_Gibbs} class object as defined in the
  topicmodels package.
}
\description{
A set of LDA topicmodels is part of the Zenodo release of GermaParl (k
between 100 and 450). These topic models can be downloaded using
\code{germaparl_download_lda} and loaded using \code{germaparl_load_lda}.
}
\details{
The function \code{germaparl_download_lda} will download an
  \code{rds}-file that will be stored in the data directory of the GermaParl
  corpus.

\code{germaparl_load_lda} will load a topicmodel into memory.
  The function will return a \code{LDA_Gibbs} topicmodel, if the topicmodel
  for \code{k} is present; \code{NULL} if the topicmodel has not yet been
  downloaded.
}
\examples{
# This example assumes that the directories used by the CWB do not yet exist, so
# temporary directories are created.
cwb_dirs <- cwbtools::create_cwb_directories(prefix = tempdir(), ask = FALSE)

samplemode <- TRUE
corpus_id <- "GERMAPARLSAMPLE" # for full corpus: corpus_id <- "GERMAPARL"

dir.create(file.path(cwb_dirs[["corpus_dir"]], tolower(corpus_id)))

# Download topic model
germaparl_download_lda(
  k = 30, # k = 250 recommended for full GERMAPARL corpus
  data_dir = file.path(cwb_dirs[["corpus_dir"]], tolower(corpus_id)),
  sample = samplemode
)
lda <- germaparl_load_lda(
  k = 30L, registry_dir = cwb_dirs[["registry_dir"]],
  sample = samplemode
)
lda_terms <- topicmodels::terms(lda, 10)
}
