% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fis_fusion.R
\docType{methods}
\name{NewFisFusion}
\alias{NewFisFusion}
\title{Create object of class "Fis" to be used in data fusion}
\usage{
NewFisFusion(
  fis_name,
  input_names,
  input_granularities,
  output_name,
  output_conclusions
)
}
\arguments{
\item{fis_name}{\link{character} vector, The name of the Fis}

\item{input_names}{\link{character} vector, The Fis inputs names}

\item{input_granularities}{\link{integer} vector, The granularity (number of membership functions) for each Fis input (granularity must be in range [2, 5])}

\item{output_name}{\link{character} vector, The name of the Fis output}

\item{output_conclusions}{\link{numeric} or \link{character} vector, The conclusions of the rules in the Fis\cr
the rules are generated according to the granularity of each input, in the lexicographic order of inputs Mfs\cr
(\code{prod(input_granularities)} rules are generated)\cr
if \link{numeric} vector, a crisp output \link{FisOutCrisp} will be added to the Fis (all output conclusions must be be in range [0, 1])\cr
if \link{character} vector, a fuzzy output \link{FisOutFuzzy} will be added to the Fis, the output_conclusions contains the labels of Mfs in the fuzzy output (labels defined on \link{FusionLabel})\cr
the length of output_conclusions must be equal to the number of generated rules.}
}
\value{
\link{Fis} object
}
\description{
Function to create object of class \link{Fis} to be used in \link{AggregFis}
}
\seealso{
\href{https://www.geofis.org/en/documentation-en/data-fusion/#linguistic-rules}{Aggregation using linguistic rules}
}
