% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.R
\name{GenericML_combine}
\alias{GenericML_combine}
\title{Combine several GenericML objects}
\usage{
GenericML_combine(x)
}
\arguments{
\item{x}{A list of \code{GenericML} objects returned by \code{\link{GenericML}}.}
}
\value{
A \code{GenericML} object as returned by \code{\link{GenericML}}. In the \code{arguments} component of this object, the objects \code{parallel}, \code{num_cores}, \code{seed}, and \code{store_learners} are set to \code{NULL} as these might differ between the individual \code{GenericML} objects in \code{x}. Moreover, the \code{propensity_scores} component of the returned object is taken from the first \code{GenericML} object in \code{x}.
}
\description{
This function combines multiple \code{GenericML} objects into one \code{GenericML} object. Combining several \code{GenericML} objects can be useful when you cannot run \code{\link{GenericML}} for sufficiently many splits due to memory constraints. In this case, you may run \code{\link{GenericML}} multiple times with only a small number of sample splits each and combine the returned \code{GenericML} objects into one \code{GenericML} object with this function.
}
\details{
To ensure consistency of the estimates, all \code{GenericML} objects in the list \code{x} must have the exact same parameter specifications in their original call to \code{\link{GenericML}}, except for the parameters \code{num_splits}, \code{parallel}, \code{num_cores}, \code{seed}, and \code{store_learners} (i.e. these arguments may vary between the \code{GenericML} objects in the list \code{x}). An error will be thrown if this is not satisfied.
}
\examples{
if (require("glmnet") && require("ranger")) {

## generate data
set.seed(1)
n  <- 150                                  # number of observations
p  <- 5                                    # number of covariates
D  <- rbinom(n, 1, 0.5)                    # random treatment assignment
Z  <- matrix(runif(n*p), n, p)             # design matrix
Y0 <- as.numeric(Z \%*\% rexp(p) + rnorm(n)) # potential outcome without treatment
Y1 <- 2 + Y0                               # potential outcome under treatment
Y  <- ifelse(D == 1, Y1, Y0)               # observed outcome

## column names of Z
colnames(Z) <- paste0("V", 1:p)

## specify learners
learners <- c("lasso", "mlr3::lrn('ranger', num.trees = 10)")

## glmnet v4.1.3 isn't supported on Solaris, so skip Lasso in this case
if(Sys.info()["sysname"] == "SunOS") learners <- learners[-1]

## call GenericML three times and store the returned objects in a list x
x <- lapply(1:3, function(...) GenericML(Z, D, Y,
                               learners, num_splits = 2,
                               parallel = FALSE))

## combine the objects in x into one GenericML object
genML <- GenericML_combine(x)

## you can use all methods of GenericML objects on the combined object, for instance accessors:
get_BLP(genML, plot = TRUE)
}

}
\seealso{
\code{\link{GenericML}}
}
