% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussSuppressDec.R
\name{GaussSuppressDec}
\alias{GaussSuppressDec}
\title{Cell suppression with synthetic decimal numbers}
\usage{
GaussSuppressDec(
  data,
  ...,
  output = NULL,
  digits = 9,
  nRep = NULL,
  rmse = pi/3,
  sparseLimit = 500,
  rndSeed = 123,
  runIpf = FALSE,
  eps = 0.01,
  iter = 100,
  mismatchWarning = TRUE,
  whenDuplicatedInner = NULL,
  whenMixedDuplicatedInner = warning
)
}
\arguments{
\item{data}{Input daata as a data frame}

\item{...}{Further parameters to \code{\link{GaussSuppressionFromData}}}

\item{output}{NULL (default), \code{"publish"}, \code{"inner"}, \code{"publish_inner"}, or \code{"publish_inner_x"} (x also).}

\item{digits}{Parameter to \code{\link{RoundWhole}}. Values close to whole numbers will be rounded.}

\item{nRep}{NULL or an integer. When >1, several decimal numbers will be generated.}

\item{rmse}{Desired root mean square error of decimal numbers.
Variability around the expected, according to the linear model, inner frequencies.
The expected frequencies are calculated from the non-suppressed publishable frequencies.}

\item{sparseLimit}{Limit for the number of rows of a reduced x-matrix within the algorithm. When exceeded, a new sparse algorithm is used.}

\item{rndSeed}{If non-NULL, a random generator seed to be used locally within the function without affecting the random value stream in R.}

\item{runIpf}{When TRUE, additional frequencies are generated by iterative proportional fitting using \code{\link{Mipf}}.}

\item{eps}{Parameter to \code{\link{Mipf}}.}

\item{iter}{Parameter to \code{\link{Mipf}}.}

\item{mismatchWarning}{Whether to produce the warning "\verb{Mismatch between whole numbers and suppression}", when relevant.
When \code{nRep>1}, all replicates must satisfy the whole number requirement for non-suppressed cells.
When \code{mismatchWarning} is integer (\verb{>0}), this will be used as parameter \code{digits} to \code{\link{RoundWhole}}
when doing mismatch checking (can be quite low when \code{nRep>1}).}

\item{whenDuplicatedInner}{Function to be called when default output and when cells marked as inner correspond to
several input cells (aggregated) since they correspond to published cells.}

\item{whenMixedDuplicatedInner}{Function to be called in the case above when some inner cells correspond
to published cells (aggregated) and some not (not aggregated).}
}
\value{
A data frame where inner cells and cells to be published are combined or output according to parameter \code{output}.
}
\description{
\code{\link{GaussSuppressionFromData}} is run and decimal numbers are added to output by
a modified (for sparse matrix efficiency) version of \code{\link{SuppressDec}}.
}
\examples{
z1 <- SSBtoolsData("z1")
GaussSuppressDec(z1, 1:2, 3)
GaussSuppressDec(z1, freqVar = "ant", formula = ~ region + hovedint, maxN = 10)
}
\author{
Øyvind Langrsud
}
