% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWPR.R
\name{GWPR}
\alias{GWPR}
\title{Geographically Weighted Panel Regression Model}
\usage{
GWPR(formula, data, index, SDF, bw = NULL, adaptive = FALSE, p = 2,
            effect = "individual", model = c("pooling", "within", "random"),
            random.method = "swar", kernel = "bisquare", longlat = FALSE)
}
\arguments{
\item{formula}{The regression formula: : Y ~ X1 + ... + Xk}

\item{data}{A data.frame for the Panel data}

\item{index}{A vector of the two indexes: (c("ID", "Time"))}

\item{SDF}{Spatial*DataFrame on which is based the data, with the "ID" in the index}

\item{bw}{The optimal bandwidth, either adaptive or fixed distance}

\item{adaptive}{If TRUE, adaptive distance bandwidth is used, otherwise, fixed distance bandwidth.}

\item{p}{The power of the Minkowski distance, default is 2, i.e. the Euclidean distance}

\item{effect}{The effects introduced in the model, one of "individual" (default) , "time", "twoways", or "nested"}

\item{model}{Panel model transformation: (c("within", "random", "pooling"))}

\item{random.method}{Method of estimation for the variance components in the random effects model, one of "swar" (default), "amemiya", "walhus", or "nerlove"}

\item{kernel}{bisquare: wgt = (1-(vdist/bw)^2)^2 if vdist < bw, wgt=0 otherwise (default);
gaussian: wgt = exp(-.5*(vdist/bw)^2);
exponential: wgt = exp(-vdist/bw);
tricube: wgt = (1-(vdist/bw)^3)^3 if vdist < bw, wgt=0 otherwise;
boxcar: wgt=1 if dist < bw, wgt=0 otherwise}

\item{longlat}{If TRUE, great circle distances will be calculated}
}
\value{
A list of result:
\describe{
\item{GW.arguments}{a list class object including the model fitting parameters for generating the report file}
\item{R2}{global r2}
\item{index}{the index used in the result, Note: in order to avoid mistakes, we forced a rename of the individuals'ID as id.}
\item{plm.result}{an object of class inheriting from plm, see plm}
\item{raw.data}{the data.frame used in the regression}
\item{GWPR.residuals}{the data.frame includes Y, Y hat, and residuals from GWPR}
\item{SDF}{a Spatial*DataFrame (either Points or Polygons, see sp) integrated with fit.points,GWPR coefficient estimates,coefficient standard errors and t-values in its data slot.}
}
}
\description{
This function implements GWPR
}
\examples{
data(TransAirPolCalif)
data(California)
formula.GWPR <- pm25 ~ co2_mean + Developed_Open_Space_perc + Developed_Low_Intensity_perc +
   Developed_Medium_Intensity_perc + Developed_High_Intensity_perc +
   Open_Water_perc + Woody_Wetlands_perc + Emergent_Herbaceous_Wetlands_perc +
   Deciduous_Forest_perc + Evergreen_Forest_perc + Mixed_Forest_perc +
   Shrub_perc + Grassland_perc + Pasture_perc + Cultivated_Crops_perc +
   pop_density + summer_tmmx + winter_tmmx + summer_rmax + winter_rmax

#precomputed bandwidth
bw.AIC.Fix <- 2.010529

result.F.AIC <- GWPR(bw = bw.AIC.Fix, formula = formula.GWPR, data = TransAirPolCalif,
                     index = c("GEOID", "year"), SDF = California, adaptive = FALSE,
                     p = 2, effect = "individual", model = "within",
                     kernel = "bisquare", longlat = FALSE)
summary(result.F.AIC$SDF$Local_R2)
library(tmap)
tm_shape(result.F.AIC$SDF) +
tm_polygons(col = "Local_R2", pal = "Reds",auto.palette.mapping = FALSE,
            style = 'cont')
}
\references{
Fotheringham, A. Stewart, Chris Brunsdon, and Martin Charlton. Geographically weighted regression: the analysis of spatially varying relationships. John Wiley & Sons, 2003.
}
\author{
Chao Li <chaoli0394@gmail.com> Shunsuke Managi
}
