% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_gtfs.R
\name{write_gtfs}
\alias{write_gtfs}
\title{Write GTFS Data to Zip File}
\usage{
write_gtfs(gtfs, zipfile, ...)
}
\arguments{
\item{gtfs}{A GTFS object. This can be in `wizardgtfs` or list format.}

\item{zipfile}{A character string specifying the path to the output zip file.}

\item{...}{Additional arguments to pass to `gtfsio::export_gtfs()`.}
}
\value{
None. This function writes the GTFS data directly to the specified `zipfile`.
}
\description{
`write_gtfs` exports a GTFS object to a zip file format, suitable for use in various GTFS-compatible software. This function supports multiple GTFS object formats and ensures compatibility by converting data frames and spatial objects as needed.
}
\details{
The function converts spatial data frames (e.g., shapes and stops) to standard data frames, removes additional service pattern tables, and exports.
}
\examples{
\dontrun{
# Export a wizardgtfs object to a zip file
write_gtfs(for_rail_gtfs, "gtfs_export.zip")
}

}
\seealso{
[GTFSwizard::read_gtfs()], [GTFSwizard::as_wizardgtfs()],
}
