% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_arguments.R
\name{check_arg_mapper}
\alias{check_arg_mapper}
\title{check_arg_mapper}
\usage{
check_arg_mapper(
  full_data,
  filter_values,
  distance_type,
  clustering_type,
  linkage_type,
  na.rm = TRUE
)
}
\arguments{
\item{full_data}{Matrix with the columns of the input matrix
corresponding to the individuals belonging to the level.}

\item{filter_values}{Vector obtained after applying the filtering function
to the input matrix, i.e, a vector with the filtering function
values for each included sample.}

\item{distance_type}{Type of distance to be used for clustering.
Choose between correlation ("cor") and euclidean ("euclidean"). "cor"
default option.}

\item{clustering_type}{Type of clustering method. Choose between
"hierarchical" and "PAM" (“partition around medoids”) options.
"hierarchical" default option.}

\item{linkage_type}{Linkage criteria used in hierarchical clustering.
Choose between "single" for single-linkage clustering, "complete" for
complete-linkage clustering or "average" for average linkage clustering
(or UPGMA). Only necessary for hierarchical clustering.
"single" default option.}

\item{na.rm}{\code{logical}. If \code{TRUE}, \code{NA} rows are omitted.
If \code{FALSE}, an error occurs in case of \code{NA} rows.}
}
\value{
\code{optimal_clustering_mode}
}
\description{
Checking the arguments introduces in the \code{mapper} object.
}
