
#' Global Surface Summary of the Day (\acronym{GSOD}) Weather Data Client
#'
#' Provides automated downloading, parsing, cleaning, unit conversion and
#' formatting of Global Surface Summary of the Day (\acronym{GSOD}) weather data
#' from the from the USA's National Centre for Environmental Information
#' (\acronym{NCEI}) for use in \pkg{R}.  All units are converted from United
#' States Customary System (\acronym{USCS}) units to International System of
#' Units (\acronym{SI}).  Stations may be individually checked for number of
#' missing days defined by the user, where stations with too many missing
#' observations are omitted.  Only stations with valid reported latitude and
#' longitude values are permitted in the final data.  Additional useful
#' elements, saturation vapour pressure ('es'), actual vapour pressure ('ea')
#' and relative humidity (RH) are calculated from the original data and included
#' in the final data set.  The resulting data include station identification
#' information, state, country, latitude, longitude, elevation, weather
#' observations and associated flags.
#'
#' Additional data are included: a list of elevation values for stations
#' between -60 and 60 degrees latitude derived from the Shuttle Radar
#' Topography Measuring Mission (\acronym{SRTM}).
#'
#' For information on the \acronym{GSOD} data from \acronym{NCEI}, please see
#' the \acronym{GSOD} readme.txt file available from,
#' \url{http://www1.ncdc.noaa.gov/pub/data/gsod/readme.txt}.
#'
#' For climate data that have been formatted specifically for use with the
#' \pkg{GSODR} package, please see the \pkg{GSODRdata} package
#' (Sparks \emph{et al}.) available from GitHub:
#' \url{https://adamhsparks.github.io/GSODRdata/}. Four data frames of
#' climate data are provided from various sources for \acronym{GSOD} station
#' locations.
#'
#' @docType package
#'
#' @name GSODR
#'
#' @author Adam Sparks, Tomislav Hengl and Andrew Nelson
#'
#' @seealso
#'
#' \strong{GSODR functions:}
#'
#' \code{\link{get_GSOD}} Download, Clean, Reformat Generate New Elements and
#' Return a Tidy Data Frame of GSOD Weather Data
#'
#' \code{\link{reformat_GSOD}} Clean, Reformat Generate New Elements and Return
#' a Tidy Data Frame of GSOD Weather Data from Local Disk
#'
#' \code{\link{nearest_stations}} Find Nearest GSOD Stations to Specified
#' a Latitude and Longitude
#'
#' \code{\link{update_station_list}} Download the Latest Station List
#' Information and Update GSODR's Internal Database
#'
#' \code{\link{get_inventory}} Download and return a tidy data frame of GSOD
#' weather station data inventories
#'
#' \strong{Useful links:}
#' \itemize{
#' \item{Static documentation at \url{https://ropensci.github.io/GSODR/}}
#' \item{Development repository at \url{https://github.com/ropensci/GSODR}}
#' \item{Report bugs at \url{https://github.com/ropensci/GSODR/issues}}
#' }
#'
#' @source
#' \url{https://data.noaa.gov/dataset/dataset/global-surface-summary-of-the-day-gsod/}
#'
#' @references
#' Karger, D. N., Conrad, O., Bohner, J., Kawohl, T., Kreft, H., Soria-Auza,
#' R. W., \emph{et al}. (2016) Climatologies at high resolution for the Earth
#' land surface areas. \emph{arXiv preprint} \bold{arXiv:1607.00217}
#'
#' New, M., Lister, D., Hulme, M., Makin, I., (2002) A high-resolution data
#' set of surface climate over global land areas. \emph{Climate Research}
#' \bold{21}:1--25
#'
#' Sparks A., Hengl T., Nelson A. (2018) GSODRdata: Extra Climate Data for
#' the GSODR Package. R package version 0.2.10,
#' \url{https://adamhsparks.github.io/GSODRdata/index.html}.
#'
#' Wilson A. M., Jetz W. (2016) Remotely Sensed High-Resolution Global Cloud
#' Dynamics for Predicting Ecosystem and Biodiversity Distributions.
#' \emph{PLoS Biol} \bold{14(3)}: e1002415. doi:10.1371/journal. pbio.1002415
#'
NULL
