% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeOneColorEncodeFunction.R
\name{makeOneColorEncodeFunction}
\alias{makeOneColorEncodeFunction}
\title{makeOneColorEncodeFunction}
\usage{
makeOneColorEncodeFunction(
  numbers,
  colors = c("#FFFFFF", "#FFFF00", "#FF0000"),
  c.fun = NULL,
  na.color = "#CCCCCC"
)
}
\arguments{
\item{numbers}{A set of numbers to define the range of numerical values for which the color encode function will be defined.
Only the extreme min and max values are necessary.}

\item{colors}{The range of colors to be returned by the function function. (default: c("#FFFFFF", "#FF0000"))}

\item{c.fun}{(optional) A function to convert numerical values into colors. If not specified, this is generated based on
\code{numbers} and \code{colors} using \code{makeLinearNColorGradientFunction()}.}

\item{na.color}{(optional) The color returned from the function for NA values (default: "#CCCCCC").}
}
\value{
The function returns a function that takes 3 arguments and returns either a vector of hexadecimal colors or a
3-column matrix of columns. The arguments:
\item{\code{numbers}}{A vector of numbers to be encoded as a color value.}
\item{\code{numbers.2}}{This argument is ignored, and is only included to be compatible with functions generated by the 2-color
encoding functions that take three arguments.}
\item{\code{output_as}}{Specifies the type of return value. If \code{'vector'} or \code{'rgb'}, the function returns a vector
of hexadecimal colors (e.g."#FFCCAA"), if 'matrix','array', a three column numeric matrix is returned (Columns are "R", "G", or "B").
Currently, \code{'vector'} are synonyms \code{'rgb'}, as are \code{'matrix'} and \code{'array'}}.
}
\description{
Generate a function to take a numerical vector and return a color, either as a vector of hexadecimal encoded
colors, or as a three column matrix.
}
\examples{

# Prepare the function:
oneColorEnc.fun <- makeOneColorEncodeFunction( numbers = c( 0.4, 6 ),
                                               colors = c("white", "yellow", "red"),
                                             )

# Encode a vector of numbers as a vector of colors:
colors_as_vector <- oneColorEnc.fun( numbers = c( 0.4, 1.2, 5, 6 ),
                                     output_as = 'vector' )

}
