% Copyright 1999-2000 by Roger S. Bivand
%
\name{rast.put}
\alias{rast.put}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Exports to GRASS raster data files}
\description{
 \code{rast.put()} moves a single numeric vector to GRASS, using the metadata from \code{gmeta()}. If the compiled function is loaded, ordered factors are assigned category labels from the factor levels.
}
\usage{
rast.put(G, lname="", layer, title="", cat=FALSE, DCELL=FALSE, breaks=NULL,
 col=NULL, nullcol=NULL, defcol=NULL, debug=FALSE, interp=FALSE, check=TRUE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
 \item{G}{GRASS metadata from \code{gmeta()}}
 \item{lname}{Name for new GRASS raster data file}
 \item{layer}{numeric vector or factor for export with length of \code{G$Ncells} in GRASS order}
 \item{title}{character string to describe new GRASS raster data file}
 \item{cat}{if TRUE, the layer is read into GRASS as integer, for codes of category factors}
 \item{DCELL}{if TRUE, the layer is read into GRASS in double precision, otherwise (default) in single precision, unless the GRASS environment variable \code{GRASS_FP_DOUBLE} is set, overriding DCELL}
 \item{breaks}{a set of breakpoints for quantization if required: must give one more breakpoint than colour; only for cat=FALSE and interp=FALSE.}
 \item{col}{a list of colors such as that generated by `rainbow', `heat.colors', `topo.colors', `terrain.colors' or similar functions; the default is a grey ramp; only for interp=FALSE, for cat=TRUE must equal number of factor levels.}
 \item{nullcol}{Colour to be used for NA values - "honeydew"}
 \item{defcol}{Default colour to be used where no other is defined - "pale turquoise"}
 \item{debug}{if TRUE, the temporary ASCII file used for transfer in interpreted mode is not deleted on exit from the function}
 \item{interp}{if TRUE, the interpreted version of the function is used instead of the loaded compiled version}
 \item{check}{if TRUE, existing raster layers will not be overwritten}
}
\details{If cat=TRUE, then the R factor layer is moved to the current GRASS location and mapset as a CELL layer, with labels taken from the factor levels; for this case breaks is disregarded (they are implicit in the factor), and col must be either NULL or a vector of colours equal in length to the number of levels. When col=NULL, grey() is used to generate the colours. If cat=FALSE, the R numeric layer is moved to GRASS as an FCELL or DCELL layer (depending on DCELL or the GRASS environmental variable \code{GRASS_FP_DOUBLE}. In this case breaks are used for quantization and colour assignment in connection with col. If breaks=NULL, pretty() is used to yield about 20 "nice" values for quantization, and their values are used to generate labels.}
\references{\url{http://grass.itc.it/statsgrass/index.html}, Bivand, R. S., (2000) Using the R statistical data analysis language on GRASS 5.0 GIS data base files. Computers and Geosciencesi, 26, pp. 1043-1052.}
\author{Roger S. Bivand, e-mail: \email{Roger.Bivand@nhh.no.}}

\note{The functions in this package are intended to work with the GRASS geographical information system. The examples for wrapper functions will will work whether or not R is running in GRASS, and whether or not the current location is that of the data set used for the examples. Examples of interface functions will however (from version 0.2-2) only work outside GRASS, to avoid possible overwriting of GRASS database locations and/or files.}

\seealso{\code{\link{rast.get}}}

\examples{
if(!get("maas.loc", env = .GRASS.meta)) make.maas.location()
data(utm.maas)
G <- gmeta()
inregion <- (utm.maas$east >= G$w & utm.maas$east <= G$e) & (utm.maas$north >= G$s & utm.maas$north <= G$n)
if(all(!inregion)) stop("None of the site locations are inside the current GRASS region")
if(any(!inregion)) warning("Some site locations are outside the current GRASS region")
require(spatial)
s3 <- trmat.G(G, surf.ls(3, utm.maas$east, utm.maas$north,
    utm.maas$Zn))*maasmask
Zn.s3.o <- as.ordered(cut(s3, labels=c("insignificant", "low",
"medium", "high", "crisis"), breaks=c(-300, 200, 400, 700, 1000, 5000), include.lowest=TRUE))
nameR <- c("ex.tr3.in", "ex.Zn.s3.o.in")
rast.put(G, lname=nameR[1], layer=s3, title="Cubic trend surface",
 check=FALSE)
rast.put(G, lname=nameR[2], layer=Zn.s3.o, cat=TRUE, 
  title="Interpolated surface categories", check=FALSE)
}
\keyword{spatial}
\keyword{IO}
