% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setInitParams.R
\name{setInitParams}
\alias{setInitParams}
\title{Initializing kernel parameters}
\usage{
setInitParams(model, grid_size = 5)
}
\arguments{
\item{model}{GP model.}

\item{grid_size}{Size of the grid over which the search for maximum likelihood will be done. Default value is 5.}
}
\value{
Return GP model with the parameters initialized at reasonable values.
}
\description{
Function for setting initial parameters to reasonable values
after performing a grid search over parameters within their  
pre-set ranges. Loglikelihood is computed for each combination 
of parameter values on the grid, and those which lead to the 
highest loglikelihood value are set as initial values.
}
\examples{
x=as.matrix(seq(1,10))
y=as.matrix(sin(x))
v=as.matrix(runif(10,0,0.5))
kernelTypes=c("rbf","white","fixedvariance")
model=constructModel(x,y,v,kernelTypes)
model=setInitParams(model)

}
\author{
Hande Topa, \email{hande.topa@helsinki.fi}
}
\keyword{initial}
\keyword{parameter}
