% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGP.R
\name{plotGP}
\alias{plotGP}
\title{Plotting fitted GP models}
\usage{
plotGP(model, col_item = "gray", ylimits = NULL, write_xticks = TRUE,
  write_yticks = TRUE, jitterx = FALSE)
}
\arguments{
\item{model}{GP model to be plotted.}

\item{col_item}{RGB color code which will be used for the color of the GP plot.}

\item{ylimits}{Numeric vector which contains minimum and maximum limits for the y axis.}

\item{write_xticks}{Boolean: whether to write x ticks and labels or not}

\item{write_yticks}{Boolean: whether to write y ticks and labels or not}

\item{jitterx}{Boolean: whether to jitter duplicated x values or not}
}
\value{
Creates the plot of the fitted GP model.
}
\description{
Function for plotting fitted GP model within its confidence region of 2 standard deviations.
}
\examples{
x=as.matrix(seq(1,10))
y=as.matrix(sin(x))
v=as.matrix(runif(10,0,0.5))
kernelTypes=c("rbf","white","fixedvariance")
model=constructModel(x,y,v,kernelTypes)
col_item=getColorVector()[1]
ylimits=c(min(y)-0.1,max(y)+0.1)
plotGP(model,col_item,ylimits)

}
\author{
Hande Topa, \email{hande.topa@helsinki.fi}
}
\keyword{plot}
