% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bbgpMeanStd.R
\name{get_bbgpMeanStd}
\alias{get_bbgpMeanStd}
\title{Computing means and standard deviations for the BBGP (beta binomial Gaussian process) model}
\usage{
get_bbgpMeanStd(x, counts, seq_depth, alpha = 1, beta = 1)
}
\arguments{
\item{x}{Time vector}

\item{counts}{Vector containing the counts data at the given time points.}

\item{seq_depth}{Vector containing the sequencing depth values at the given time points.}

\item{alpha}{alpha parameter of the beta binomial model.}

\item{beta}{beta parameter of the beta binomial model.}
}
\value{
Return list containing the posterior means and standard deviations of the frequencies
at the time points where sequencing depth is larger than zero. x vector is updated so
that it excludes the time points with zero sequencing depth, i.e. time points at which
no data have been observed. Posterior means and standard deviations and the updated x vecor
are assigned to the list elements named 'posteriorMean', 'posteriorStd', and 'time', respectively.
}
\description{
Function for obtaining the posterior means and standard deviations
for the frequencies (counts divided by sequencing depth)
by using the counts and sequencing depth values in a
beta binomial model. Parameters (alpha and beta) of the
model are set to 1 by default, which keeps symmetry between
f and (1-f), where f denotes the frequency valued between
(0,1).
}
\examples{
x=c(1,2,3,4,5)
counts=c(12,54,32,0,34)
seq_depth=c(50,70,35,0,40)
bbgp=get_bbgpMeanStd(x,counts,seq_depth)
x=bbgp$time # updated time vector
y=bbgp$posteriorMean # posterior means
v=bbgp$posteriorStd^2 # posterior variances

}
\author{
Hande Topa, \email{hande.topa@helsinki.fi}
}
\keyword{bbgp}
