% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gotermlevelmf.R
\name{GOTermMFOnLevel}
\alias{GOTermMFOnLevel}
\title{GO molecular function (MF) term level getter}
\usage{
GOTermMFOnLevel(goterm)
}
\arguments{
\item{goterm}{An object of class character. A character string of GO molecular function (MF) terms.
The object can be a GO-term or a vector of GO-terms}
}
\value{
A two-column matrix of the GO-terms and the level they map to
}
\description{
Gets the level of a molecular function (MF) term based on the directed acyclic graph (DAG)
             defined by the Gene Ontology consortium
}
\note{
The Gene Ontology (GO) molecular function (MF) tree was built using the root node "GO:0003674"
}
\examples{
# molecular function GO terms

goterms <- c("GO:0003674","GO:0005515","GO:0003712","GO:0002039","GO:0000978","GO:0016740")

GOTermMFOnLevel(goterms)

GOTermMFOnLevel("GO:0005542")

}
