% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialise.R
\name{make_agents}
\alias{make_agents}
\title{Agent initialisation}
\usage{
make_agents(model = "IBM", agent_number = 2, type_counts = c(1, 1),
  move = 0, vision = 20, rows = 100, cols = 100)
}
\arguments{
\item{model}{The type of model being applied (Currently only individual-based
-- i.e., 'agent-based' -- models are allowed)}

\item{agent_number}{This is the number of agents that are set in the model; agent number does not change during the simulation, and each agent has a unique ID}

\item{type_counts}{A vector of how many agents there are of each type (element). The sum of this vector needs to equal the agent_number so that each agent can correctly be assigned a type. Currently, GMSE assumes that there are only two types of agents: managers (type 0) and stakeholders (type 1), and only one manager exists. Future versions of GMSE will allow for different options as requested.}

\item{move}{This parameter affects the movement of agents each time step. There are multiple types of movement (see obs_move_type in the gmse function), but this parameter determines the distance in cells that an agent will move. Agent movement is generally less important than resource movement, and typically does not affect how agents interact with resources}

\item{vision}{This parameter determines the distance around an agent's location within which it can observe resources. This is relevant for some (but not not all) types of observation in the observation model, particularly for density-based estimation (observe_type = 0 in the gmse() function).}

\item{rows}{The number of rows (y-axis) on the simulated landscape; agents are randomly placed somewhere on the landscape array}

\item{cols}{The number of columns (x-axis) on the simulated landscape; agents are randomly placed somewhere on the landscape array}
}
\value{
the_agents Initialised data frame of agents being modelled
}
\description{
Initialise the agents of the G-MSE model.
}
\examples{
agents <- make_agents(model = "IBM", agent_number = 2, type_counts = c(1, 1), 
move = 0, vision = 20, rows = 100, cols = 100);
}
