% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_cosinor.R
\name{print.cglmmSubTest}
\alias{print.cglmmSubTest}
\title{Print test of model}
\usage{
\method{print}{cglmmSubTest}(x, ...)
}
\arguments{
\item{x}{A \code{sub_test_cosinor} object.}

\item{...}{Additional, ignored arguments.}
}
\value{
\code{print(x)} returns \code{x} invisibly.
}
\description{
Print test of model
}
\examples{
data_2_component <- simulate_cosinor(
  n = 10000,
  mesor = 5,
  amp = c(2, 5),
  acro = c(0, pi),
  beta.mesor = 4,
  beta.amp = c(3, 4),
  beta.acro = c(0, pi / 2),
  family = "gaussian",
  n_components = 2,
  period = c(10, 12),
  beta.group = TRUE
)
mod_2_component <- cglmm(
  Y ~ group + amp_acro(times,
    n_components = 2, group = "group",
    period = c(10, 12)
  ),
  data = data_2_component
)
test_output <- test_cosinor_levels(
  mod_2_component,
  param = "amp",
  x_str = "group"
)
print(test_output$global.test)
}
