% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_coverage.R
\name{GIFT_coverage}
\alias{GIFT_coverage}
\title{Taxonomic and trait coverage per geographic region and taxonomic group in
GIFT}
\usage{
GIFT_coverage(
  what = "taxonomic_coverage",
  taxon_name = "Embryophyta",
  trait_ID = "1.1.1",
  GIFT_version = "latest",
  api = "https://gift.uni-goettingen.de/api/extended/"
)
}
\arguments{
\item{what}{character indicating whether \code{taxonomic_coverage} or
\code{trait_coverage} shall be retrieved.}

\item{taxon_name}{Name of the taxonomic group you want to retrieve coverage
for. See \code{\link[=GIFT_taxonomy]{GIFT_taxonomy()}} for details.}

\item{trait_ID}{Identification number of the trait you want to retrieve
coverage for. See \code{\link[=GIFT_traits_meta]{GIFT_traits_meta()}} for details.}

\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the \code{latest} stable
version. If set to \code{beta}, the most up-to-date version which is still
subject to changes and edits is used.}

\item{api}{character string defining from which API the data will be
retrieved.}
}
\value{
A data frame with either taxonomic or trait coverage per
GIFT polygon.
}
\description{
Retrieve taxonomic or trait coverage (for a given trait) of all species,
native species, naturalized species and endemic species per taxonomic group
and geographic region combination.
}
\details{
The output has 9 columns:

\emph{entity_ID} - Identification number of GIFT polygons\cr
\emph{total} - taxonomic or trait coverage for all species\cr
\emph{total_rst} - taxonomic or coverage for all species considering
restricted resources\cr
\emph{native} - taxonomic or trait coverage for native species\cr
\emph{native_rst} - taxonomic or trait coverage for native species
considering restricted resources\cr
\emph{naturalized} - taxonomic or trait coverage for naturalized species\cr
\emph{naturalized_rst} - taxonomic or trait coverage for naturalized species
considering restricted resources\cr
\emph{endemic_min} - taxonomic or trait coverage for endemic species\cr
\emph{endemic_min_rst} - taxonomic or trait coverage for endemic species
considering restricted resources

In the case of taxonomic coverage, a '1' means that species composition data
is available for the given combination of taxonomic group and geographic
region while 'NA' means that no data is available. This can differ depending
on whether restricted data in GIFT is considered or not (columns with or
without _rst at the end).

In the case of trait coverage, the proportion of species of a given
taxonomic group with information on the defined trait is reported per
geographic region.
}
\examples{
\donttest{
ex <- GIFT_coverage(what = "taxonomic_coverage", taxon_name = "Angiospermae")
ex2 <- GIFT_coverage(what = "trait_coverage", taxon_name = "Angiospermae",
trait_ID = "1.2.1")
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_traits_meta]{GIFT_traits_meta()}}
}
