% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpairs_add.R
\name{ggmatrix_location}
\alias{ggmatrix_location}
\title{\code{\link{ggmatrix}} plot locations}
\usage{
ggmatrix_location(pm, location = NULL, rows = NULL, cols = NULL)
}
\arguments{
\item{pm}{\code{\link{ggmatrix}} plot object}

\item{location}{\describe{
  \item{\code{"all"}, \code{TRUE}}{All row and col combinations}
  \item{\code{"none"}}{No row and column combinations}
  \item{\code{"upper"}}{Locations where the column value is higher than the row value}
  \item{\code{"lower"}}{Locations where the row value is higher than the column value}
  \item{\code{"diag"}}{Locations where the column value is equal to the row value}
  \item{\code{matrix} or \code{data.frame}}{
    \code{matrix} values will be converted into \code{data.frame}s.
    \itemize{
      \item A \code{data.frame} with the exact column names \code{c("row", "col")}
      \item A \code{data.frame} with the number of rows and columns matching the plot matrix object provided.  Each cell will be tested for a "truthy" value to determine if the location should be kept.
    }
  }
}}

\item{rows}{numeric vector of the rows to be used. Will be used with  \code{cols} if \code{location} is \code{NULL}}

\item{cols}{numeric vector of the cols to be used. Will be used with \code{rows} if \code{location} is \code{NULL}}
}
\value{
Data frame with columns \code{c("row", "col")} containing locations for the plot matrix
}
\description{
\lifecycle{experimental}
}
\details{
Convert many types of location values to a consistent \code{data.frame} of \code{row} and \code{col} values.
}
\examples{
pm <- ggpairs(reshape::tips, 1:3)

# All locations
ggmatrix_location(pm, location = "all")
ggmatrix_location(pm, location = TRUE)

# No locations
ggmatrix_location(pm, location = "none")

# "upper" triangle locations
ggmatrix_location(pm, location = "upper")

# "lower" triangle locations
ggmatrix_location(pm, location = "lower")

# "diag" locations
ggmatrix_location(pm, location = "diag")

# specific rows
ggmatrix_location(pm, rows = 2)

# specific columns
ggmatrix_location(pm, cols = 2)

# row and column combinations
ggmatrix_location(pm, rows = c(1,2), cols = c(1,3))

# matrix locations
mat <- matrix(TRUE, ncol = 3, nrow = 3)
mat[1,1] <- FALSE
locs <- ggmatrix_location(pm, location = mat)
## does not contain the 1,1 cell
locs

# Use the output of a prior ggmatrix_location
ggmatrix_location(pm, location = locs)
}
