% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GGUM2004.R
\name{export.GGUM2004}
\alias{export.GGUM2004}
\title{Exports data in 'GGUM2004' friendly format}
\usage{
export.GGUM2004(data, data.file = "data", data.dir = tempdir())
}
\arguments{
\item{data}{The R data matrix to be exported.}

\item{data.file}{A character string defining the name of the data file. No 
file extension is required.}

\item{data.dir}{A character string defining the path to the directory where 
the data file (possibly exported by function 
\code{\link[GGUM]{export.GGUM2004}}) is stored. By default a temporary 
directory is used, but the user can naturally specify a directory of her 
choice.}
}
\description{
\code{export.GGUM2004} exports the data from R to a text file 
  according to the format required by 'GGUM2004'
}
\section{Details}{
 This function exports the R matrix \code{data} in 'GGUM2004'
  (Roberts, Donoghue, & Laughlin, 2000; Roberts et al., 2006) friendly
  format. This data file is to be used together with a 'GGUM2004' command
  script (or using the GUI itself, of course). 'GGUM2004' may be executed
  directly or may be called from R, see \code{\link[GGUM]{run.GGUM2004}}.
  
  By experience, we noticed that long directory paths (especially if spaces 
  are included) make 'GGUM2004' fail to execute with error 
  \code{file not found}. Therefore, a good advice is to choose 
  \code{data.dir} wisely (short paths, no spaces).
  
  Observe that this function is optimized for the Windows operating system 
  because 'GGUM2004' is a Windows program.
}

\examples{
# Generate data:
C   <- c(3, 3, 3, 5, 5, 5)
I   <- 6
gen <- GenData.GGUM(750, I, C, seed = 125)
# Export data to 'GGUM2004':
export.GGUM2004(gen$data)

}
\references{
\insertRef{Robertsetal2000}{GGUM}

\insertRef{Robertsetal2006}{GGUM}
}
\author{
Jorge N. Tendeiro, \email{j.n.tendeiro@rug.nl}
}
