% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kl.R
\name{kl_mvn}
\alias{kl_mvn}
\title{Kullback-Leibler Divergence}
\usage{
kl_mvn(true, estimate, stein = FALSE)
}
\arguments{
\item{true}{Matrix. The true precision matrix
(inverse of the covariance matrix)}

\item{estimate}{Matrix. The estimated precision matrix
(inverse of the covariance matrix)}

\item{stein}{Logical. Should Stein's loss be computed
(defaults to \code{TRUE})? Note KL divergence is
half of Stein's loss.}
}
\value{
Numeric corresponding to KL divergence.
}
\description{
Compute KL divergence for a multivariate normal distribution.
}
\note{
A lower value is better, with a score of zero indicating that
the estimated precision matrix is identical to the true precision matrix.
}
\examples{
\donttest{

# nodes
p <- 20

main <- gen_net(p = p, edge_prob = 0.15)

y <- MASS::mvrnorm(250, rep(0, p), main$cors)

fit_l1 <- ggmncv(R = cor(y),
              n = nrow(y),
              penalty = "lasso",
              progress = FALSE)

# lasso
kl_mvn(fit_l1$Theta, solve(main$cors))

fit_atan <- ggmncv(R = cor(y),
              n = nrow(y),
              penalty = "atan",
              progress = FALSE)

kl_mvn(fit_atan$Theta, solve(main$cors))

}
}
