% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.GFisher.R
\name{stat.GFisher}
\alias{stat.GFisher}
\title{Generalized Fisher's p-value combination statistic.}
\usage{
stat.GFisher(p, df = 2, w = 1)
}
\arguments{
\item{p}{- vector of input p-values.}

\item{df}{- vector of degrees of freedom for inverse chi-square transformation for each p-value. If all df's are equal, it can be defined by the constant.}

\item{w}{- vector of weights.}
}
\value{
GFisher statistic sum_i w_i*qchisq(1 - p_i, df_i).
}
\description{
Generalized Fisher's p-value combination statistic.
}
\examples{
n = 10
pval = runif(n)
stat.GFisher(pval, df=2, w=1)
stat.GFisher(pval, df=rep(2,n), w=rep(1,n))
stat.GFisher(pval, df=1:n, w=1:n)
}
\references{
Hong Zhang and Zheyang Wu. "Accurate p-Value Calculation for Generalized Fisher's Combination Tests Under Dependence", <arXiv:2003.01286>.
}
