% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifyGENEA.R
\name{classifyGENEA}
\alias{classifyGENEA}
\title{Classify Data into Categories defined in an rpart GENEA fit}
\usage{
classifyGENEA(
  testfile,
  start = NULL,
  end = NULL,
  Use.Timestamps = FALSE,
  radians = FALSE,
  mmap.load = (.Machine$sizeof.pointer >= 8),
  trainingfit = trainingFit,
  newdata,
  allprobs = FALSE,
  setinf = 100,
  outputname = "_classified",
  outputdir = "GENEAclassification",
  datacols = "default",
  changepoint = c("UpDownDegrees", "TempFreq", "UpDownFreq", "UpDownMean", "UpDownVar",
    "UpDownMeanVar", "DegreesMean", "DegreesVar", "DegreesMeanVar",
    "UpDownMeanVarDegreesMeanVar", "UpDownMeanVarMagMeanVar"),
  penalty = "Manual",
  pen.value1 = 40,
  pen.value2 = 400,
  intervalseconds = 30,
  mininterval = 5,
  samplefreq = 100,
  filterorder = 2,
  boundaries = c(0.5, 5),
  Rp = 3,
  plot.it = FALSE,
  hysteresis = 0.1,
  stft_win = 10,
  plot.seg = FALSE,
  plot.seg.outputfile = "Changepoint",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{testfile}{character string stating path to a GENEActiv bin file, or a folder 
containing GENEActiv bin files.}

\item{start}{Where to start reading observations.}

\item{end}{Where to end reading observations.}

\item{Use.Timestamps}{To use timestamps as the start and end time values this has to be set to TRUE. (Default FALSE)}

\item{radians}{calculate degrees rotation in radians.}

\item{mmap.load}{Default is (.Machine$sizeof.pointer >= 8). see \code{\link[mmap]{mmap}} for more details}

\item{trainingfit}{a GENEA rpart object created by \code{\link{createGENEAmodel}} 
that gives the decision tree that was fitted from the training data. 
These are the parameters used to predict the new data.}

\item{newdata}{a new data frame that is to be classified (provide instead of testfile). 
The data must contain the \code{\link{features}} named in the trainingfit.}

\item{allprobs}{single logical should all estimated probabilities be 
reported rather than probability of selected class (default \code{FALSE}).}

\item{setinf}{single numeric an arbitrary value to replace Inf in calculated 
columns or NA to ignore Inf values. (default 100).
-setinf is used to replace -Inf. Alternatively, use setinf NULL to leave Inf as is.}

\item{outputname}{file name root (excluding extension) for saving the 
classification output (default "classified").}

\item{outputdir}{absolute or relative path to directory in which artifacts 
(plot and changes files) should be created or \code{NULL} 
(default "GENEAclassification").}

\item{datacols}{a vector constructed 'column.summary' or 'default'. See \code{\link{segmentation}} for details.}

\item{changepoint}{defines the change point analysis to use. UpDownDegrees performs the change point analysis on the variance of arm elevation and wrist rotation. TempFreq performs a change point on the variance in the temeprature and Frequency (Typically better for sleep behaviours)}

\item{penalty}{single characgter, the penalty to use for changepoint detection. default ("SIC")}

\item{pen.value1}{Value of the type 1 error required when penalty is "Asymptotic".}

\item{pen.value2}{Default set as NULL and so equals pen.value1 if no input.}

\item{intervalseconds}{An integer number of seconds between 5 and 30 during which at most one changepoint may occur.}

\item{mininterval}{single numeric that defines the smallest changepoint initially found. Passed to \code{\link[changepoint]{cpt.var}} as the variable minseglen}

\item{samplefreq}{The sampling frequency of the data, in hertz,
when calculating the step number. (default 100)}

\item{filterorder}{The order of the filter applied with respect to the cheby options.}

\item{boundaries}{to passed to the filter in the step counting algorithm.}

\item{Rp}{the decibel level that the cheby filter takes. see \code{\link[signal]{cheby1}}}

\item{plot.it}{(logical) Creates a plot showing the zero crossings counted by the step counting algorithm#' @param Centre Centres the xz signal about 0 when set to True.}

\item{hysteresis}{The hysteresis applied after zero crossing. (default 100mg)}

\item{stft_win}{Window size in seconds for STFT computation. Increased window size mean better frequency resolution, but poorer time resolution. Defaults to 10 seconds.}

\item{plot.seg}{(logical) Creates a plot displaying the changepoint locations}

\item{plot.seg.outputfile}{The name of the png file created that shows the change points on a positionals plots.}

\item{verbose}{single logical should additional progress reporting be 
printed at the console (default \code{TRUE}).}

\item{...}{other arguments to be passed to \code{\link{dataImport}}, 
\code{\link{segmentation}} and other functions}
}
\value{
The function will return the data frame that was provided as newdata with 
additional columns. \enumerate{
    \item \code{Class}, a factor indicating that the predicted category of the segment
    \item \code{p.Class}, estimated probability that the prediction is correct
}
Alternatively, by setting argument allprobs to TRUE, a column constructed 
'p.level' containing the estimated probability of each possible class 
will be returned instead.
}
\description{
Perform classification on segmented GENEActiv bin data using an 
rpart GENEA training fit.
}
\details{
This function will apply the rules determined by the rpart GENEA 
decision tree passed to argument trainingfit to the columns 
of newdata to classify into classes 
(view using \code{"\link[=levels.GENEA]{levels}"}).
}
\examples{
## segData <- read.csv(system.file(package = "GENEAclassify", 
##       "testdata", "trainingData9.csv"))
## The training fit can be created by provided the file path to the training data
## in the function getTrainingData - see the help file for more details
## Uses the fitted decision tree to predict the segmented data
## class9 <- classifyGENEA(testfile = "trainingData9.csv",
##                         newdata = segData, 
##                         trainingfit = trainingFit)
## head(class9)
## table(class9$Class)
}
