% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{HNSCC}
\alias{HNSCC}
\title{A data frame containing the TCGA head and neck squamous cell carcinoma (HNSCC) data.}
\format{
A data frame with 484 rows and 2009 variables.
}
\usage{
data(HNSCC)
}
\description{
A data frame containing the 7 environmental (E)
effects (the first 7 columns), 2000 genetic (G) effects (column 8 to column 2007), logarithm of survival time
(column 2008), and censoring indicator (column 2009). All of them can be downloaded  from TCGA Provisional using the
R package \code{cgdsr}. See details.
}
\details{
There are seven E effects, namely alcohol consumption frequency (ACF), smoking pack
years (SPY), age, gender, PN, PT, and ICD O3 site. For G effects, 2,000 gene
expressions are considered. Among 484 subjects, 343 subjects have missingness in ACF and/or SPY.
For G effects, we analyze mRNA gene expressions. A total of 18,409 gene expression
measurements are available, then prescreening is conducted using marginal Cox models, finally,
the top 2,000 genes with the smallest p-values are selected for downstream analysis.
}
\examples{
data(HNSCC)
E=as.matrix(HNSCC[,1:7])
G=as.matrix(HNSCC[,8:2007])
Y=as.matrix(HNSCC[,2008:2009])
\donttest{
fit<-Miss.boosting(G,E,Y,im_time=10,loop_time=1000,v=0.25,num.knots=5,degree=3,tau=0.3,
family="survival",E_type=c(rep("EC",3),rep("ED",4)))
plot(fit)
}
}
\keyword{datasets}
