% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makePolicyHeadTailAdjustment.R
\name{makePolicyHeadTailAdjustment}
\alias{makePolicyHeadTailAdjustment}
\title{Make a Policy of Head and/or Tail Adjustment for a Timeline Model}
\usage{
makePolicyHeadTailAdjustment(
  type = c("both", "tail", "head", "none"),
  gr = 0,
  np
)
}
\arguments{
\item{type}{a character string specifying the type of the policy, must be one of "both" (default), "head", "tail" or "none".
If type=="none", NULL will be returned.}

\item{gr}{the growth rate.}

\item{np}{the number of economic periods.}
}
\value{
A policy, which is often used as an argument of the function sdm2.
}
\description{
Make a policy of head and/or tail adjustment for a timeline model.
A timeline model is an intertemporal non-sequential model that includes production and a given initial product supply.
Head adjustment refers to the adjustment of the initial product supply to a steady-state value.
Similarly, tail adjustment refers to the adjustment of the share coefficient of the last period of the consumer in the timeline model in order to let the model run in a steady-state equilibrium path.
}
\note{
The statement policy = makePolicyHeadTailAdjustment(gr = gr, np = np) is equivalent to
policy = list( makePolicyHeadAdjustment(ind = c(1, np, 2, 1), gr = gr), makePolicyTailAdjustment(ind = c(np - 1, np), gr = gr) ).
}
\seealso{
{
\code{\link{gemIntertemporal_Dividend}};
\code{\link{gemIntertemporal_Money_Dividend_Example7.5.1}}
}
}
