% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GDS_givencols.R
\name{GDS_givencols}
\alias{GDS_givencols}
\title{Gauss-Dantzig Selector}
\source{
Cand{\`e}s, E. and Tao, T. (2007). The Dantzig selector: Statistical estimation when p is much
larger than n. Annals of Statistics 35 (6), 2313--2351.

Dopico-Garc{\' i}a, M.S., Valentao, P., Guerra, L., Andrade, P. B., and Seabra, R. M. (2007).
Experimental design for extraction and quantification of phenolic
compounds and organic acids in white "Vinho Verde" grapes
Analytica chimica acta, 583(1): 15--22.

Hamada, M. and Wu, C. F. J. (1992). Analysis of designed experiments
with complex aliasing. Journal of Quality Technology 24 (3), 130--137.

Hunter, G. B., Hodi, F. S. and Eagar, T. W. (1982). High cycle fatigue of weld repaired
cast Ti-6AI-4V. Metallurgical Transactions A 13 (9), 1589--1594.

Phoa, F. K., Pan, Y. H. and Xu, H. (2009). Analysis of supersaturated
designs via the Dantzig selector. Journal of Statistical Planning and Inference
139 (7), 2362--2372.

Singh, R. and Stufken, J. (2022). Factor selection in screening experiments
by aggregation over random models, 1--31. \doi{10.48550/arXiv.2205.13497}
}
\usage{
GDS_givencols(delta.n = 10, design, Y, which.cols = c("main2fi"))
}
\arguments{
\item{delta.n}{a positive integer suggesting the number of deltas
to be tried. \code{delta.n} values of \code{delta} will be used
strictly between 0 and \code{max(t(X)y)}. The default value is
set to 10.}

\item{design}{a \eqn{n \times m}{n x m} matrix of \code{m} two-level main effects.
The columns should have the high-level coded as +1 and the low-level codes as -1.}

\item{Y}{a vector of \code{n} responses.}

\item{which.cols}{a string with either \code{main} or \code{main2fi}. Denotes
whether the Gauss-Dantzig Selector should be run on the main effect columns (\code{main}), or on
all main effects plus all 2 factor interaction columns (\code{main2fi}).
The default value is \code{main2fi}.}
}
\value{
A list returning the effects identified as active as well as the
corresponding identified important factors.
}
\description{
This function runs Gauss-Dantzig Selector on the given columns.
We have two options: either (a) GDS(m) on the \code{m} main
effects, and (b) GDS(m+2fi) on the \code{m} main effects plus two-factor interactions.
For a given \code{delta}, DS minimizes the l1-norm (sum of absolute values)
of \code{beta} subject to the constraint that \code{max(t(X)(y-X * beta))} <= \code{delta}.
GDS is run for multiple values of \code{delta}. We use kmeans with 2
clusters and BIC to select a best model  for all the \code{delta} values.
}
\examples{
data(dataHamadaWu)
X = dataHamadaWu[,-8]
Y= dataHamadaWu[,8]
delta.n=10
# GDS on main effects 
GDS_givencols(delta.n,design = X, Y=Y, which.cols = "main")

# GDS on main effects and two-factor interactions
GDS_givencols(delta.n,design = X, Y=Y)

data(dataCompoundExt)
X = dataCompoundExt[,-9]
Y= dataCompoundExt[,9]
delta.n=10
# GDS on main effects
GDS_givencols(delta.n,design = X, Y=Y, which.cols = "main")
# GDS on main effects and two-factor interactions
GDS_givencols(delta.n,design = X, Y=Y, which.cols = "main2fi")
}
\seealso{
\code{\link{GDSARM}}, \code{\link{dantzig.delta}}
}
