% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCmodel.R
\name{MCmodel}
\alias{MCmodel}
\title{Multiple-choice models}
\usage{
MCmodel(dat, Qc, model = "MCDINA", key = NULL, conv.crit = 0.001,
  maxitr = 2000, conv.type = "pr")
}
\arguments{
\item{dat}{A required \eqn{N \times J} data matrix of N examinees to J items. Values must be 1, 2,... representing nominal categories.
Missing values are currently not allowed.}

\item{Qc}{A required category and attribute association matrix.
The first column gives the item number, which must
be numeric (i.e., 1,2,...) and match the number of column in the data.
The second column indicates the coded category of each item. The number in the second column must match
with the number in the data, but if a category is not coded, it should not be included in the Q-matrix.
Entry 1 indicates that the attribute is measured by the category, and 0 otherwise.
Note that the MC-DINA model assumes that the category with the largest number of 1s is the key and that the coded distractors should
allow to assign examinees uniquely.}

\item{model}{\code{MCDINA} only currently. Other MC models may be incorporated.}

\item{key}{a numeric vector giving the key of each item. See \code{Examples}.
\code{NULL} by default indicating the coded category requiring the largest number of 1s is the key.}

\item{conv.crit}{The convergence criterion for max absolute change in \code{conv.type} for two consecutive iterations.}

\item{maxitr}{The maximum iterations allowed.}

\item{conv.type}{convergence criteria; Can be \code{pr} or \code{LL},
indicating category response function, or -2 times log-likelihood,respectively.}
}
\value{
an object of class \code{MCmodel} with the following components:
\describe{
\item{prob.parm}{A list of success probabilities for each reduced latent class on each item (IRF)}
\item{prob.se}{A list of standard errors of item parameters}
\item{attribute}{A list of estimated attribute profiles including EAP, MLE and MAP estimates.}
\item{testfit}{A list of test fit statistics including deviance, number of parameters, AIC and BIC}
\item{R}{expected # of individuals in each latent group choosing each option}
\item{lik}{posterior probability}
\item{itr}{Total # of iterations}
}
}
\description{
This function estimates the multiple-choice DINA model (de la Torre, 2009).
}
\examples{
\dontrun{
 # check the format of the data
 # Entry 0 is not allowed
 head(sim10MCDINA$simdat)

 #---------------------------------
 # check the format of the Q-matrix
 #---------------------------------
 # Take item 1 as an example:
 # category 2 has a q-vector (1,0,0)
 # category 1 has a q-vector (0,1,0)
 # category 4 has a q-vector (1,1,0)
 # category 3 is not included in the Q-matrix because it is not coded
 # the order of the coded categories in the Q-matrix doesn't matter

 sim10MCDINA$simQ
  #     Item coded cat A1 A2 A3
  #        1         2  1  0  0
  #        1         1  0  1  0
  #        1         4  1  1  0
  #...
 est <- MCmodel(sim10MCDINA$simdat,sim10MCDINA$simQ)
 est
 est$testfit

 #--------------------------------------
 # Distractors involving more attributes
 #--------------------------------------
 # some distractors may involve attributes that are not invovled by the key option
 # this is not allowed by the "original" MC-DINA (de la Torre, 2009) but is allowed
 # in the current implementation

 # Users need to specify the key for each item to appropriate handle such an issue
 # Note item 1 below: category 1 is the key (as indicated in the key argument below)
 # The distractor (category 4) involves an attribute not included by the key option

 Qc <- matrix(c(1,	1,	1,	1,	0,
                1,	2,	0,	1,	0,
                1,	3,	1,	0,	0,
                1,	4,	1,	0,	1,
                2,	1,	1,	0,	0,
                2,	3,	1,	1,	0,
                2,	2,	1,	1,	1,
                3,	4,	1,	1,	1,
                3,	2,	1,	1,	0,
                3,	3,	0,	1,	1,
                4,	1,	0,	1,	1,
                4,	2,	0,	0,	1,
                5,	1,	1,	0,	0,
                6,	3,	0,	1,	0,
                7,	2,	0,	0,	1,
                8,	4,	1,	0,	0,
                9,	1,	0,	1,	0,
                10, 4,	0,	0,	1),ncol = 5,byrow = TRUE)

 est2 <- MCmodel(sim10MCDINA$simdat,Qc, key = c(1,2,4,1,1,3,2,4,1,4))
 est2
 est2$prob.parm
 est2$testfit
 est2$attribute
}
}
\references{
De La Torre, J. (2009). A cognitive diagnosis model for cognitively based multiple-choice options. \emph{Applied Psychological Measurement, 33}, 163--183.
}
\seealso{
\code{\link{GDINA}} for G-DINA model
}
\author{
{Wenchao Ma, The University of Alabama, \email{wenchao.ma@ua.edu}}
}
