% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotIRF.GDINA.R
\name{plot.Qval}
\alias{plot.Qval}
\title{Mesa plot for Q-matrix validation}
\usage{
\method{plot}{Qval}(x, item, type = "best", no.qvector = 10,
  data.label = TRUE, eps = "auto", original.q.label = FALSE,
  auto.ylim = TRUE, ...)
}
\arguments{
\item{x}{model object of class \code{Qvalidation}}

\item{item}{a vector specifying which item(s) the plots are drawn for}

\item{type}{types of the plot. It can be \code{"best"} or \code{"all"}. If \code{"best"},
for all q-vectors requiring the same number of attributes, only the one with the largest PVAF
is plotted, which means \eqn{K_j} q-vectors are plotted; If \code{"all"}, all q-vectors
will be plotted.}

\item{no.qvector}{the number of q vectors that need to be plotted when \code{type="all"}. The default is 10,
which means the 10 q vectors with the largest PVAFs are plotted.}

\item{data.label}{logical; To show data label or not?}

\item{eps}{the cutoff for PVAF. If not \code{NULL}, it must be a value between 0 and 1. A horizontal line will be drawn accordingly.}

\item{original.q.label}{logical; print the label showing the original q-vector or not?}

\item{auto.ylim}{logical; create y range automatically or not?}

\item{...}{additional arguments passed to \code{plot} function}
}
\description{
The mesa plot was first proposed by de la Torre and Ma (2016) for graphically illustrating the best q-vector(s) for each item.
The q-vector on the edge of the mesa is likely to be the best q-vector.
}
\examples{
\dontrun{
dat <- sim10GDINA$simdat
Q <- sim10GDINA$simQ
Q[1,] <- c(0,1,0)
mod1 <- GDINA(dat = dat, Q = Q, model = "GDINA")
out <- Qval(mod1,eps = 0.9)
item <- c(1,2,10)
plot(out,item=item,data.label=FALSE,type="all")
plot(out,item=10,type="best",eps=0.95)
plot(out,item=10,type="all",no.qvector=5)
}

}
\references{
de la Torre, J., & Ma, W. (2016, August). Cognitive diagnosis modeling: A general framework approach and its implementation in R. A Short Course at the Fourth Conference on Statistical Methods in Psychometrics, Columbia University, New York.
}
\seealso{
\code{\link{Qval}}, \code{\link{autoGDINA}}
}
