% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdm.R
\name{gdm}
\alias{gdm}
\alias{print.gdm}
\alias{plot.gdm}
\title{Geographical detectors: a one-step function.}
\usage{
gdm(formula, continuous_variable = NULL, data = NULL, discmethod, discitv)
\method{print}{gdm}(x, ...)
\method{plot}{gdm}(x, ...)
}
\arguments{
\item{formula}{A formula of response and explanatory variables}

\item{continuous_variable}{A vector of continuous variable names}

\item{data}{A data.frame includes response and explanatory variables}

\item{discmethod}{A character vector of discretization methods}

\item{discitv}{A numeric vector of numbers of intervals}

\item{x}{A list of \code{gdm} result}

\item{...}{Ignore}
}
\description{
A one-step function for optimal discretization and geographical detectors for
multiple variables and visualization.
}
\examples{
###############
## NDVI: ndvi_40
###############
## set optional parameters of optimal discretization
## optional methods: equal, natural, quantile, geometric, sd and manual
discmethod <- c("equal","quantile")
discitv <- c(4:5)
## "gdm" function
ndvigdm <- gdm(NDVIchange ~ Climatezone + Mining + Tempchange,
               continuous_variable = c("Tempchange"),
               data = ndvi_40,
               discmethod = discmethod, discitv = discitv)
ndvigdm
plot(ndvigdm)
\dontrun{
#############
## H1N1: h1n1_100
#############
## set optional parameters of optimal discretization
discmethod <- c("equal","natural","quantile")
discitv <- c(4:6)
continuous_variable <- colnames(h1n1_100)[-c(1,11)]
## "gdm" function
h1n1gdm <- gdm(H1N1 ~ .,
               continuous_variable = continuous_variable,
               data = h1n1_100,
               discmethod = discmethod, discitv = discitv)
h1n1gdm
plot(h1n1gdm)
}

}
