% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_functions.R
\name{AsymCI_local_loading}
\alias{AsymCI_local_loading}
\title{Get an asymptotic confidence interval for the local component}
\usage{
AsymCI_local_loading(object, i, j, alpha = 0.05)
}
\arguments{
\item{object}{An S3 object of class 'multi_result' created by multilevel().}

\item{i}{An integer indicating the \eqn{i}-th block.}

\item{j}{An integer indicating the \eqn{j}-th individual in the \eqn{i}-th block.}

\item{alpha}{The significance level, a single numeric between 0 and 1. 0.05 by default.}
}
\value{
A matrix containing the upper and lower band.
}
\description{
This function computes the asymptotic confidence intervals
for the local loadings for the \eqn{j}-th individual in block \eqn{i}.
See Lin and Shin (2023) for details.
}
\examples{
\donttest{
panel <- UKhouse # load the data
est_multi <- multilevel(panel, ic = "BIC3", standarise = TRUE, r_max = 5,
                           depvar_header = "dlPrice", i_header = "Region",
                           j_header = "LPA_Type", t_header = "Date")
bs_local_loading_11 <- AsymCI_local_loading(est_multi, i = 1, j = 1)
}
}
\references{
Lin, R. and Shin, Y., 2022. Generalised Canonical Correlation Estimation
of the Multilevel Factor Model. Available at SSRN 4295429.
}
