% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_alphacuts_17102018.R
\name{tr.gfuzz}
\alias{tr.gfuzz}
\title{Fuzzifies a variable modelled by trapezoidal or triangular fuzzy numbers}
\usage{
tr.gfuzz(data, breakpoints = 100)
}
\arguments{
\item{data}{a matrix of 4 columns (p,q,r,s), where p \eqn{\le} q \eqn{\le} r \eqn{\le} s. No NA are allowed.}

\item{breakpoints}{a positive arbitrary integer representing the number of breaks chosen to build the numerical alpha-cuts. breakpoints is fixed to 100 by default.}
}
\value{
A 3-dimensional array with dimensions (m,n,2), i.e. m lines, n columns, with no NA.
}
\description{
Fuzzifies a variable modelled by trapezoidal or triangular fuzzy numbers
}
\examples{
data <- matrix(c(1,1,2,2,3,3,4,4),ncol=4)
data.tr <- tr.gfuzz(data)
}
