% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyInferenceSystem.R
\name{newfis}
\alias{newfis}
\title{Create a fis using newfis function}
\usage{
newfis(
  fisName,
  fisType = "mamdani",
  mfType = "t1",
  andMethod = "min",
  orMethod = "max",
  impMethod = "min",
  aggMethod = "max",
  defuzzMethod = "centroid"
)
}
\arguments{
\item{fisName}{String representing the fis name.}

\item{fisType}{Type of the fis, default is 'mamdani'.}

\item{mfType}{Type of membership functions, 't1' or 'it2'}

\item{andMethod}{The AND method for the fis, default is 'min'.}

\item{orMethod}{The OR method for the fis, default is 'max'.}

\item{impMethod}{The implication method for the fis, default is 'min'.}

\item{aggMethod}{The aggregation method for the fis, default is 'max'.}

\item{defuzzMethod}{The defuzzification method for the fis, default is 'centroid'.}
}
\value{
A new fis structure.
}
\description{
Creates a fis object.
}
\examples{
fis <- newfis("fisName")
}
