% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/class-01-FuzzyNumber.R
\docType{class}
\name{FuzzyNumber-class}
\alias{FuzzyNumber-class}
\title{S4 class Representing a Fuzzy Number}
\description{
Formally, a fuzzy number \eqn{A} (Dubois, Prade, 1987) is a fuzzy subset of the
real line \eqn{R}  with membership function \eqn{\mu} given by:
\tabular{lll}{
                   \tab | \eqn{0}                      \tab if \eqn{x    < a1}, \cr
                   \tab | \eqn{left((x-a1)/(a2-a1))}   \tab if \eqn{a1 \le x  < a2}, \cr
\eqn{\mu(x)}     = \tab | \eqn{1}                      \tab if \eqn{a2 \le x  \le a3}, \cr
                   \tab | \eqn{right((x-a3)/(a4-a3))}  \tab if \eqn{a3   < x  \le a4}, \cr
                   \tab | \eqn{0}                      \tab if \eqn{a4   < x}, \cr
}
where \eqn{a1,a2,a3,a4\in R}, \eqn{a1 \le a2 \le a3 \le a4},
\eqn{left: [0,1]\to[0,1]}{left: [0,1]->[0,1]} is a nondecreasing function
called the \emph{left side generator of \eqn{A}},
and \eqn{right: [0,1]\to[0,1]}{right: [0,1]->[1,0]} is a nonincreasing function
called the \emph{right side generator of \eqn{A}}.
Note that this is a so-called L-R representation of a fuzzy number.

Alternatively, it may be shown that each fuzzy number \eqn{A} may be uniquely determined
by specifying its \eqn{\alpha}-cuts, \eqn{A(\alpha)}. We have \eqn{A(0)=[a1,a4]} and
\deqn{A(\alpha)=[a1+(a2-a1)*lower(\alpha), a3+(a4-a3)*upper(\alpha)]}
for \eqn{0<\alpha\le 1}, where \eqn{lower: [0,1]\to[0,1]}{lower: [0,1]->[0,1]}
and \eqn{upper: [0,1]\to[0,1]}{upper: [0,1]->[1,0]}
are, respectively, strictly increasing and decreasing functions
satisfying \eqn{lower(\alpha)=\inf\{x: \mu(x)\ge\alpha\}}{lower(\alpha)=inf(x: \mu(x)\ge\alpha)}
and  \eqn{upper(\alpha)=\sup\{x: \mu(x)\ge\alpha\}}{upper(\alpha)=sup(x: \mu(x)\ge\alpha)}.
}
\details{
Please note that many algorithms that deal with fuzzy numbers often use
\eqn{\alpha}-cuts rather than side functions.

Note that the \pkg{FuzzyNumbers} package also deals with particular types
of fuzzy numbers like trapezoidal, piecewise linear, or ``parametric'' FNs.
}
\section{Slots}{

 \describe{
   \item{\code{a1}:}{Single numeric value specifying the left bound for the support.}
   \item{\code{a2}:}{Single numeric value specifying the left bound for the core.}
   \item{\code{a3}:}{Single numeric value specifying the right bound for the core.}
   \item{\code{a4}:}{Single numeric value specifying the right bound for the support.}
   \item{\code{lower}:}{A nondecreasing function [0,1]->[0,1] that gives the lower alpha-cut bound.}
   \item{\code{upper}:}{A nonincreasing function [0,1]->[1,0] that gives the upper alpha-cut bound.}
   \item{\code{left}:}{A nondecreasing function [0,1]->[0,1] that gives the left side function.}
   \item{\code{right}:}{A nonincreasing function [0,1]->[1,0] that gives the right side function.}
 }
}

\section{Child/sub classes}{

\code{\linkS4class{TrapezoidalFuzzyNumber}},
\code{\linkS4class{PiecewiseLinearFuzzyNumber}},
\code{\linkS4class{PowerFuzzyNumber}}, and
\code{\linkS4class{DiscontinuousFuzzyNumber}}
}
\examples{
showClass("FuzzyNumber")
showMethods(classes="FuzzyNumber")
}
\references{
Dubois D., Prade H. (1987), Fuzzy numbers: An overview, In: Analysis of Fuzzy
Information. Mathematical Logic, vol. I, CRC Press, pp. 3-39.
}
\seealso{
\code{\link{FuzzyNumber}} for a convenient constructor, and
\code{\link{as.FuzzyNumber}} for conversion of objects to this class.
Also, see \code{\link{convertSide}} for creating side functions generators,
\code{\link{convertAlpha}} for creating alpha-cut bounds generators,
\code{\link{approxInvert}} for inverting side functions/alpha-cuts numerically.

Other FuzzyNumber-method: \code{\link{*,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{*,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{*,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{*,TrapezoidalFuzzyNumber,numeric-method}},
  \code{\link{*,numeric,FuzzyNumber-method}},
  \code{\link{+,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{+,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{+,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{+,TrapezoidalFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{+,numeric,FuzzyNumber-method}},
  \code{\link{-,FuzzyNumber,ANY-method}},
  \code{\link{-,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{-,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{-,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{-,TrapezoidalFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{-,numeric,FuzzyNumber-method}},
  \code{\link{/,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{/,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{/,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{Arithmetic}}; \code{\link{FuzzyNumber}};
  \code{\link{alphaInterval}},
  \code{\link{alphaInterval,FuzzyNumber-method}},
  \code{\link{alphaInterval,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{alphaInterval,PowerFuzzyNumber-method}},
  \code{\link{alphaInterval,TrapezoidalFuzzyNumber-method}};
  \code{\link{alphacut}},
  \code{\link{alphacut,FuzzyNumber,numeric-method}};
  \code{\link{ambiguity}},
  \code{\link{ambiguity,FuzzyNumber-method}};
  \code{\link{as.FuzzyNumber}},
  \code{\link{as.FuzzyNumber,FuzzyNumber-method}},
  \code{\link{as.FuzzyNumber,numeric-method}};
  \code{\link{as.PiecewiseLinearFuzzyNumber}},
  \code{\link{as.PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{as.PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{as.PiecewiseLinearFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{as.PiecewiseLinearFuzzyNumber,numeric-method}};
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber,FuzzyNumber-method}},
  \code{\link{as.PowerFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{as.PowerFuzzyNumber,PowerFuzzyNumber-method}},
  \code{\link{as.PowerFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{as.PowerFuzzyNumber,numeric-method}};
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber,FuzzyNumber-method}},
  \code{\link{as.TrapezoidalFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{as.TrapezoidalFuzzyNumber,PowerFuzzyNumber-method}},
  \code{\link{as.TrapezoidalFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{as.TrapezoidalFuzzyNumber,numeric-method}};
  \code{\link{as.character}},
  \code{\link{as.character,FuzzyNumber-method}},
  \code{\link{as.character,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{as.character,PowerFuzzyNumber-method}},
  \code{\link{as.character,TrapezoidalFuzzyNumber-method}};
  \code{\link{core}},
  \code{\link{core,FuzzyNumber-method}};
  \code{\link{distance}},
  \code{\link{distance,DiscontinuousFuzzyNumber,DiscontinuousFuzzyNumber-method}},
  \code{\link{distance,DiscontinuousFuzzyNumber,FuzzyNumber-method}},
  \code{\link{distance,FuzzyNumber,DiscontinuousFuzzyNumber-method}},
  \code{\link{distance,FuzzyNumber,FuzzyNumber-method}};
  \code{\link{evaluate}},
  \code{\link{evaluate,FuzzyNumber,numeric-method}};
  \code{\link{expectedInterval}},
  \code{\link{expectedInterval,FuzzyNumber-method}},
  \code{\link{expectedInterval,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{expectedInterval,PowerFuzzyNumber-method}},
  \code{\link{expectedInterval,TrapezoidalFuzzyNumber-method}};
  \code{\link{expectedValue}},
  \code{\link{expectedValue,FuzzyNumber-method}};
  \code{\link{integrateAlpha}},
  \code{\link{integrateAlpha,DiscontinuousFuzzyNumber,character,numeric,numeric-method}},
  \code{\link{integrateAlpha,FuzzyNumber,character,numeric,numeric-method}};
  \code{\link{piecewiseLinearApproximation}},
  \code{\link{piecewiseLinearApproximation,FuzzyNumber-method}};
  \code{\link{plot}},
  \code{\link{plot,DiscontinuousFuzzyNumber,missing-method}},
  \code{\link{plot,FuzzyNumber,missing-method}},
  \code{\link{plot,PiecewiseLinearFuzzyNumber,missing-method}},
  \code{\link{plot,TrapezoidalFuzzyNumber,missing-method}};
  \code{\link{show}},
  \code{\link{show,FuzzyNumber-method}};
  \code{\link{supp}},
  \code{\link{supp,FuzzyNumber-method}};
  \code{\link{trapezoidalApproximation}},
  \code{\link{trapezoidalApproximation,FuzzyNumber-method}};
  \code{\link{value}},
  \code{\link{value,FuzzyNumber-method}};
  \code{\link{weightedExpectedValue}},
  \code{\link{weightedExpectedValue,FuzzyNumber-method}};
  \code{\link{width}},
  \code{\link{width,FuzzyNumber-method}}
}

