% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_ccircle_spatial_methods.R
\name{plot.fe_ccircle_spatial}
\alias{plot.fe_ccircle_spatial}
\title{Plot an fe_ccircle_spatial Object}
\usage{
\method{plot}{fe_ccircle_spatial}(x, tree_filter = TRUE, dbh_scale = 1, show_labels = FALSE, ...)
}
\arguments{
\item{x}{An \code{fe_ccircle_spatial} object}

\item{tree_filter}{A \code{data-masking} expression that applies to the
data.frame \code{x$trees}. It must return a logical value, and is defined
in terms of the variables in \code{x$trees}. In this function, it is used
internally in order to define the cohort of trees which is to be evaluated
by this function (within a call to \code{dplyr::filter()}). While many
meaningful filterings are conceivable, distinctions between total stand,
removal stand, and remaining stand are the most probable applications.
Defaults to \code{TRUE}, i.e. all trees are included. See examples.}

\item{dbh_scale}{Scaling factor for plotting tree dbh in order to allow
oversized representations. Defaults to 1 (correct scaling)}

\item{show_labels}{Logical value. If TRUE, labels for species, dbh, R and
angle are displayed.}

\item{...}{Additional arguments, not used in \code{plot.fe_ccircle_spatial}}
}
\value{
A map (ggplot2) of the plot layout including the trees with
coordinates
}
\description{
Plot an fe_ccircle_spatial Object
}
\examples{
 opt_old <- getOption("fe_spec_lang") # store user's current setting
 options(fe_spec_lang = "eng")      # choose Englisch species name display
 spruce_pine_ccircle_spatial |> plot()
 spruce_pine_ccircle_spatial |> plot(dbh_scale = 4)
 spruce_pine_ccircle_spatial |>
   plot(
     dbh_scale = 4,
     tree_filter = species_id == fe_species_tum_wwk_long(30) & dbh_cm > 35
   )
 options(fe_spec_lang = opt_old)

}
