% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecursiveForecastModel

%Two new commands to help with formatting
\newcommand{\methodtable}{\bold{\cr #1 \cr} \tabular{lcl}}
\newcommand{\methoditem}{\emph{#1} \tab-\tab #2\cr}
\newcommand{\methodname}{\subsection{#1}}
\docType{class}
\name{RecursiveForecastModel
}
\alias{RecursiveForecastModel
}
\title{RecursiveForecastModel
}
\description{A model for recursively predicting multiple timesteps into the
 future.  This class implements a particular type of forecasting, where a
 predict method is called to predict each successive time step in order.
 Extend this class if you have a predict method, but not a special forecast
 method.
}
\seealso{
Is inherited by : \code{\link{MoveAheadModel}}}
\section{Fields}{
\describe{
\item{data}{A MatrixData containing the data used in fitting of the model.
}
\item{maxPredCol}{The farthest back column from the output value used in prediction.
}
\item{predCols}{An array of which columns are used in prediction.  1 means the column before the prediction, 2 the one before that etc.
}
\item{stochastic}{A string with the family of stochastic noise to apply to the recursive process.  Currently only accepts 'Deterministic' and 'Poisson' as values.
}
}}
\section{Methods}{
\methodname{fit(data)}{
Fit the model for predicting.  This method breaks down the fitting  process into two parts, data preparation, and the model fitting.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{data}{The data to use to fit the model.  This object should be a  MatrixData object.
}
}}}}
\methodname{fit_()}{
This method \bold{must} be extended.  Fit the model for predicting all of the rows. Assumes the data has been  put into place.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
}}}}
\methodname{forecast(newdata = private$.data,steps=1)}{
Using a model previously fit with \code{fit} to predict the next \code{steps} columns.  This function assumes that all of the data preprocessing has already been taken care of.  This function is similar to predict, except that it can predict multiple time steps into the future instead of a single timestep.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{newdata}{The data to forecast from.
}
\methoditem{steps}{The number of timesteps into the future to predict.
}
}}
\item{Value}{private$output This function should both modify and return private$output.
}
}}
\methodname{predict(newdata)}{
Use a model previously fit with fit to predict. This function does not assume any data preprocessing.  This function should not, in general need  to be overwritten by the user.  The main prediction function is predict_, so please modify that function instead if possible.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{newdata}{Optional.  The data used to predict.  This data should be a MatrixData object.
}
}}}}
\methodname{predictRow(newdata,row,col)}{
Using a model previously fit with \code{fitRow} to predict the  \code{row}th row of the next column. This function does not assume any data preprocessing.  Since the predict method predicts every row at the  the same time, we include this method for predicting only a single row.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{newdata}{Optional.  The data use to predict.  This can either be a matrix, appropriately formatted lag vector, or NULL to predict based on the data used to fit.
}
\methoditem{row}{The row to predict the value of.
}
\methoditem{col}{This is for internal use only.
}
}}}}
\methodname{predictRow_(row)}{
This method \bold{must} be extended.  Using a model previously fit with \code{fitRow} to predict the  \code{row}th row of the next column. This function assumes that all of the data preprocessing has already been taken care of.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{row}{The row to predict the value of.
}
}}
\item{Value}{private$output The return value should be both stored in  private$output and returned using return.  This should contain the  results of the prediction in a Forecast object with dimensions similar to private$newdata.
}
}}
\methodname{predict_(col=0)}{
This method \bold{must} be extended.  Using a model previously fit with \code{fit} to predict each row of the  next column. This function assumes that all of the data preprocessing has already been taken care of.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{col}{Which columns of private$output should be modified.  This  parameter is mainly used in forecast, but could be used to store repeated predict_ calls in a single matrix.
}
}}
\item{Value}{private$output The return value should be both stored in  private$output and returned using return.  This should contain the  results of the prediction in a Forecast object with dimensions similar to private$newdata.
}
}}
\methodname{prepareFitData(data)}{
This method \bold{must} be extended.  Take \code{data} and store it in the object.  This allows the data to be referenced later in predict() where newdata is NULL.  It may also be helpful to put other data preparation steps in this method, so that the fit function runs more smoothly.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{data}{ The data to prepare.
}
}}}}
\methodname{prepareForecastData(data)}{
This method \bold{must} be extended.  This function takes input data and prepares it to forecast.  It should in  principle, be similar to preparePredictData, but sometimes forecasting  requires different preparation from prediction.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{data}{The data to prepare for forecasting from.
}
}}
\item{Value}{private$newdata Store the processed value here, so that forecast can access it.
}
}}
\methodname{prepareOutputData(inputData,steps=0)}{
This method \bold{must} be extended.  This function takes the input data and constructs an appropriate container for the output of the model.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{inputData}{The input to the model.  Used to determine properties of the container.
}
\methoditem{steps}{If the input data is used as part of a forecast, the number of steps is passed in case the output size depends on the number of time steps.
}
}}}}
\methodname{preparePredictData(newdata)}{
This method \bold{must} be extended.  Take \code{newdata} and use it to prepare the model, so that predicting doesn't need to directly reference it.  This allows the model to make multiple predict_, predictRow_, or forecast calls without re-allocating the data every time.
\describe{\item{\emph{Arguments}}{\tabular{lcl}{
\methoditem{newdata}{ The data to prepare.
}
}}}}
}
