% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commat.R
\name{commat}
\alias{commat}
\title{Commutation matrix}
\usage{
commat(r, c)
}
\arguments{
\item{r}{Number of rows of \code{Y}.}

\item{c}{Number of columns of \code{Y}.}
}
\value{
A sparse (\code{(r c) x (r c)}) matrix.
}
\description{
This function returns the (\code{(r c) x (r c)}) commutation matrix \code{P} such that
\deqn{P vec(Y) = vec(Y'),}
where \code{Y} is a (\code{r x c}) matrix.
}
\examples{
Y <- matrix(rnorm(30), 5, 6)
P <- commat(5, 6)
P \%*\% as.vector(Y) == as.vector(t(Y)) # check
}
\references{
Magnus, J.R., Neudecker, H. (2019), Matrix Differential Calculus with Applications
in Statistics and Econometrics, third edition, New York, Wiley, pp. 54-55.
}
\keyword{utilities}
