% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{estimatePhinu_nondiag}
\alias{estimatePhinu_nondiag}
\title{Estimate non-diagonal VAR(1) parameters after mean removal}
\usage{
estimatePhinu_nondiag(
  epsilons,
  Sig_nu_diag,
  Phi_diag,
  replace_diag = FALSE,
  needReproduce = FALSE
)
}
\arguments{
\item{epsilons}{Numeric matrix of dimension \eqn{n \times p},
representing the estimated residuals
\eqn{\boldsymbol{\epsilon}_t = \mathbf{y}_t - \hat{\boldsymbol{\mu}}_t}.}

\item{Sig_nu_diag}{Numeric \eqn{p \times p} diagonal matrix providing
initial (diagonal) estimates of \eqn{\Sigma_{\boldsymbol{\nu}}}.}

\item{Phi_diag}{Numeric \eqn{p \times p} diagonal matrix providing
initial (diagonal) estimates of \eqn{\Phi}.}

\item{replace_diag}{Logical; if \code{TRUE}, replaces the diagonal
entries of the estimated matrices with those from
\code{Sig_nu_diag} and \code{Phi_diag} (default \code{FALSE}).}

\item{needReproduce}{Logical; if \code{TRUE}, uses fixed fold assignments
in cross-validation to ensure reproducibility (default \code{FALSE}).}
}
\value{
A list containing:
\itemize{
  \item `Phi_hat` — Estimated non-diagonal autoregressive matrix
    \eqn{\Phi}.
  \item `Sig_nu_hat` — Estimated non-diagonal innovation covariance
    matrix \eqn{\Sigma_{\boldsymbol{\nu}}}.
}
}
\description{
Estimates the non-diagonal autoregressive coefficient matrix
\eqn{\Phi} and innovation covariance matrix \eqn{\Sigma_{\boldsymbol{\nu}}}
for the residual process obtained after removing the estimated
fluctuating mean from the data. The estimation applies the
Lasso to encourage sparsity in the cross-variable dependence structure.
}
\details{
The function applies a Lasso-penalized VAR(1) fit to the residual
process \eqn{\boldsymbol{\epsilon}_t} to estimate cross-dependencies
among variables.
The fitting is performed using the function
\code{fitVAR()}, which is adapted from the \pkg{sparsevar} package.
When \code{replace_diag = TRUE}, the diagonal entries of
\eqn{\Phi} and \eqn{\Sigma_{\boldsymbol{\nu}}} are replaced by
their componentwise estimates obtained in Phase I for improved
numerical stability.
}
