% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_completeness.R
\name{check_completeness}
\alias{check_completeness}
\title{Check Completeness}
\usage{
check_completeness(
  data,
  st_yr,
  nd_yr,
  allowed = 3,
  period = 10,
  pad = NULL,
  my = NULL
)
}
\arguments{
\item{data}{Result from \code{\link{missingness}}.}

\item{st_yr}{Starting year of the desired period.}

\item{nd_yr}{Ending year of the desired period.}

\item{allowed}{Maximum number of years allowed to be missing in the period.}

\item{period}{Period of years that cannot exceed an allowed gap.}

\item{pad}{Optional number of years to pad the data set.}

\item{my}{Optional maximum number of years allowed to be missing with padding.}
}
\value{
A list containing:
  \itemize{
    \item TRUE or FALSE indicating conditions were met or not
    \item code: 0 "met", 1 "not long enough period", 2 "gaps longer than allowed",
and 3 "more gaps in period than allowed", 10 "met with pad",
11 "not long enough period with pad", 12 "gaps longer than allowed with pad",
and 13 "more gaps in period than allowed with pad"
  }

Messages indicating the reason for failure
}
\description{
Determine if the desired completeness criteria are being met. This considers if the
date range of interest is complete, and whether internal gaps are longer than the
criteria. There is an option for allowing the data set to be padded with an optional number
of years and then tested using the same criteria. Function returns TRUE if the
criteria are met and FALSE if not, and a numeric code that indicates the mode of failure
or success.
}
\examples{
robin_path <- system.file("extdata", "ROBIN_example.csv", package = "FlowScreen")

TS <- read.flows(robin_path)
res <- missingness(TS, title = TRUE)
check_completeness(res, st_yr = 1985, nd_yr = 2014, allowed = 3, period = 10)

}
\author{
Paul Whitfield
}
