% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bf.stats.R
\name{bf.stats}
\alias{bf.stats}
\title{Baseflow statistics}
\usage{
bf.stats(TS, by = "hyear")
}
\arguments{
\item{TS}{output from \code{\link{create.ts}} containing a data.frame of flow
time series}

\item{by}{summary period.  Options are "year", "hyear", "month", or "doy".
Default is "hyear".}
}
\value{
Returns a data.frame with the following columns:
  \itemize{
    \item By - Unique values representing the summary periods, e.g. a list of
      unique years, months, or days of year 
    \item MeanQ - Mean daily streamflow for the summary period, in m3/s 
    \item MeanBF - Mean daily baseflow for the summary period, in m3/s 
    \item MaxBF - Maximum daily baseflow for the summary period, in m3/s 
    \item MinBF - Minimum daily baseflow for the summary period, in m3/s 
    \item BFVol - Baseflow volume for the summary period, in km3 
    \item MeanBFI - Mean daily baseflow index for the summary period, dimensionless 
    \item MaxBFI - Maximum daily baseflow index for the summary period, dimensionless 
    \item MinBFI - Minimum daily baseflow index for the summary period, dimensionless 
  }
}
\description{
This function estimates the baseflow and calculates the mean, max, and min
baseflow and baseflow index for a user defined time period.
}
\details{
This function calls \code{\link{bf_eckhardt}} to complete the 
  baseflow separation.
}
\examples{
data(cania.sub.ts)

res <- bf.stats(cania.sub.ts)
res2 <- screen.metric(res[,2], "m3/s")
}
\author{
Jennifer Dierauer
}
