% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predictive.R
\name{summary.flexreg_postpred}
\alias{summary.flexreg_postpred}
\title{Summary Method for \code{`flexreg_postpred`} objects}
\usage{
\method{summary}{flexreg_postpred}(object, ...)
}
\arguments{
\item{object}{an object of class \code{`flexreg_postpred`} containing the simulated posterior predictives, usually the result of \code{\link{posterior_predict}}.}

\item{...}{additional arguments.}
}
\value{
The function \code{\link{summary.flexreg_postpred}} returns an array with the statistical units by row. The number of rows of the array is equal to the number of columns of the object of class \code{`flexreg_postpred`} that is given to the function.
By column there are some synthesis values that are the minimum, the first quartile, the media, the mean, the third quartile, and the maximum.
}
\description{
Summary method for an object of class \code{`flexreg_postpred`}, containing the simulated posterior predictive distribution.
}
\examples{
\dontrun{
data("Reading")
FB <- flexreg(accuracy ~ iq, data = Reading)
pp <- posterior_predict(FB)
summary(pp)
}

}
