% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predictive.R
\name{posterior_predict.flexreg}
\alias{posterior_predict.flexreg}
\title{Posterior Predictive}
\usage{
\method{posterior_predict}{flexreg}(model, newdata = NULL)
}
\arguments{
\item{model}{an object of class \code{`flexreg`}}

\item{newdata}{an optional data frame containing variables with which to predict. If omitted, the fitted values are used.}
}
\value{
An object of class \code{`flexreg_postpred`} containing a matrix with the simulated posterior predictions. Each column refers to a statistical unit to predict.
}
\description{
The function takes an object of class \code{`flexreg`} and generates values from the posterior predictive distribution.
}
\details{
The function generates values from the posterior predictive distribution, which is the distribution of a  future outcome given the observed data.
}
\examples{
data("Reading")
dataset <- Reading
FB <- flexreg(accuracy ~ iq, dataset, n.iter=1000)
pp <- posterior_predict(FB)
plot(pp)

}
\references{
{Gelman, A.; Carlin, J. B.; Stern, H. S. and Rubin, D. B. (2014), Bayesian Data Analysis, 3th edition. Chapman and Hall/CRC. doi:10.1201/b16018}
}
