% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fl_DownloadFjord.R
\name{fl_DownloadFjord}
\alias{fl_DownloadFjord}
\title{Download fjord PAR data as NetCDF files.}
\usage{
fl_DownloadFjord(fjord, dirdata = NULL)
}
\arguments{
\item{fjord}{Expects a character vector for one of the 8 available fjords.
See \code{\link{fl_ListFjords}} for the list of possible choices.}

\item{dirdata}{The directory where the user would like to download the data.
Default is "FjordLight.d".}
}
\value{
The downloaded NetCDF file contains the following variables:
  \item{bathymetry}{depth [m]}
  \item{land}{elevation [m]}
  \item{area}{PixelArea_km2 [m]}
  \item{AreaOfCoastalZone}{Surface of Sea floor with a depth of between 0 and 200 meters [km2]}
  etc...
}
\description{
This functions queries the FTP server where the NetCDF files are stored. It will
retrieve the one file that matches the name provided to it via the \code{fjord}
argument. Note that these files can be multiple gigabytes in size.
}
\examples{
# Choose a fjord
fjord_code <- "test"

# Download it
# NB: One should provide a permanent directory when downloading a file.
fl_DownloadFjord(fjord_code, dirdata = tempdir())


}
\author{
Bernard Gentili
}
