% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct.meas.R
\name{correct.meas}
\alias{correct.meas}
\title{Correction of Metabolic Rate Measurements}
\usage{
correct.meas(info.data, pre.data, post.data, meas.data,
             method = c("pre.test", "post.test", "average",
                        "linear", "exponential", "parallel"),
             empty.chamber = c("CH1", "CH2", "CH3", "CH4",
                               "CH5", "CH6", "CH7", "CH8"))
}
\arguments{
\item{info.data}{a data frame obtained by using the function \code{\link{input.info}}}

\item{pre.data}{a data frame obtained by using the function \code{\link{import.test}} for a blank test before actual metabolic rate measurements}

\item{post.data}{a data frame obtained by using the function \code{\link{import.test}} for a blank test after actual metabolic rate measurements}

\item{meas.data}{a data frame obtained by using the function \code{\link{import.meas}} for actual metabolic rate measurements}

\item{method}{string: the name of the method used for background respiration correction:
\itemize{
\item  "pre.test" - subtracts oxygen consumption of pre.data from oxygen consumptions of meas.data
\item  "post.test" - subtracts oxygen consumption of post.data from oxygen consumptions of meas.data
\item  "average" - subtracts an averaged oxygen consumption of pre.data and\cr post.data from oxygen consumptions of meas.data
\item  "linear" - subtracts a vector of progressively changing microbial consumptions from oxygen consumptions of meas.data. The values of oxygen consumption are linearly predicted from two reference points: oxygen consumption of pre.data and oxygen consumption of post.data.
\item  "exponential" - subtracts a vector of progressively changing microbial consumptions from oxygen consumptions of meas.data. The values of oxygen consumption are exponentially predicted from two reference points: oxygen consumption of pre.data and oxygen consumption of post.data.
\item  "parallel" - subtracts oxygen consumption in an empty chamber from oxygen consumptions of meas.data for each chamber
}}

\item{empty.chamber}{string: the name of an empty chamber used only for the method 'parallel'}
}
\value{
The function returns a data frame containing data of metabolic rate measurements corrected for background respiration. The data frame is used in the functions \code{\link{QC.meas}}, \code{\link{QC.activity}},\cr \code{\link{extract.slope}} and \code{\link{QC.slope}}.
}
\description{
The function is used to correct metabolic rate measurements for background respiration. To this end, oxygen consumption is estimated as the slope of the linear regression of measured \eqn{O_{2}} concentration over time, and is extracted for background respiration test and for each measurement phase. The correction is based on subtraction of oxygen consumption obtained during background respiration test from oxygen consumption obtained during metabolic rate measurements.
}
\examples{
# if the data have been already loaded to R,
# skip the first five lines of the code:
data(info)
data(pre)
data(post)
data(AMR.raw)
\dontrun{
data(SMR.raw)
SMR.clean <- correct.meas(info.data = info,
                          pre.data = pre,
                          meas.data = SMR.raw,
                          method = "pre.test")
}

AMR.clean <- correct.meas(info.data = info,
                          post.data = post,
                          meas.data = AMR.raw,
                          method = "post.test")

}
\references{
{Svendsen, M. B. S., Bushnell, P. G., & Steffensen, J. F. (2016). Design and setup of intermittent-flow respirometry system for aquatic organisms. Journal of Fish Biology, 88(1), 26-50.}
}
