% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03.people.R
\name{find.people}
\alias{find.people}
\title{Extract all the unique people associated to at least one of the provided \code{firm} objects}
\usage{
find.people(..., who = c("managers", "owners", "both", "all"), sorting = TRUE)
}
\arguments{
\item{...}{Either multiple objects of class \code{firm} or a list of such objects}

\item{who}{Whether to extract the 'managers' or the 'owners' (minimum unambiguous string)}

\item{sorting}{Whether to sort the people by alphabetical order. Defaults to \code{TRUE}}
}
\value{
A vector containing the names of the individuals looked up. If
}
\description{
Extract all the unique people associated to at least one of the provided \code{firm} objects
}
\examples{
# Find all the shareholders in companies that Berkshire Hathaway holds
data('firms_BKB')
shareholders <- find.people(firms_BKB, who = 'own')

# Find all those managing the companies that Berkshire Hathaway holds
data('firms_BKB')
managers <- find.people(firms_BKB, who = 'man')

}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
