% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SSURGO_FUNCTIONS.R
\name{getSSURGOStudyArea}
\alias{getSSURGOStudyArea}
\title{Download and crop the spatial and tabular data for a SSURGO study area.}
\usage{
getSSURGOStudyArea(template = NULL, area, date, raw.dir)
}
\arguments{
\item{template}{A Raster* or Spatial* object to serve
as a template for cropping. If missing, whose study area is returned}

\item{area}{A character string indicating the SSURGO study area to be downloaded.}

\item{date}{A character string indicating the date of the most recent update to the SSURGO
area for these data. This information may be gleaned from the SSURGO Inventory (\code{\link{getSSURGOInventory}}).}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created if missing.}
}
\value{
A \code{SpatialPolygonsDataFrame} of the SSURGO study areas within
the specified \code{template}.
}
\description{
\code{getSSURGOStudyArea} returns a named list of length 2:
\enumerate{
\item "spatial": A \code{SpatialPolygonsDataFrame} of soil mapunits
in the template, and
\item "tabular": A named list of \code{\link{data.frame}s} with the SSURGO tabular data.
}
}

