% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FateID_functions.R
\name{prcurve}
\alias{prcurve}
\title{Computation of a principal curve for a given dimensional reduction representation}
\usage{
prcurve(y, fb, dr, k = 2, m = "cmd", trthr = NULL, start = NULL, ...)
}
\arguments{
\item{y}{clustering partition. A vector with an integer cluster number for each cell. The order of the cells has to be the same as for the columns of x.}

\item{fb}{fateBias object returned by the function \code{fateBias}.}

\item{dr}{list of dimensional reduction representations returned by the function \code{compdr}.}

\item{k}{integer number for the dimension to be used. This dimension has to be present in \code{dr}. Default value is 2.}

\item{m}{name of the dimensional reduction algorithms to be used for the principal curve computation. One of \code{lle}, \code{cmd}, \code{dm}, \code{tsne}, \code{umap}. Default value is \code{cmd}. Has to be a component of \code{dr}, i.e. previously computed by \code{compdr}.}

\item{trthr}{real value representing the threshold of the fraction of random forest votes required for the inclusion of a given cell for the computation of the principal curve. If \code{NULL} then only cells with a significant bias >1 are included for each trajectory. The bias is computed as the ratio of the number of votes for a trajectory and the number of votes for the trajectory with the second largest number of votes. By this means only the trajectory with the largest number of votes will receive a bias >1. The siginifcance is computed based on counting statistics on the difference in the number of votes. A significant bias requires a p-value < 0.05. Default value is \code{NULL}.}

\item{start}{integer number representing a specified starting cluster number for all trajectories, i. e. a common progenitor cluster. The argument is optional. Default value is \code{NULL}.}

\item{...}{additional arguments to be passed to the low level function \code{principal_curve}.}
}
\value{
A list of the following two components:
  \item{pr}{A list of principal curve objects produced by the \code{principal_curve} function from the \pkg{princurve} package. Each component corresponds to one differentiation trajectory giving rise to one of the target clusters from the \code{fb} object.}
  \item{trc}{A list of ordered cell IDs for each trajectory in \code{pr}.}
}
\description{
This function computes a principal curve for a given dimensional reduction representation which is specified by component names of an object returned by \code{compdr} using the \pkg{princurve} package.
}
\details{
The function computes a principal curve for each differentiation trajectory by considering only cells that are assigned to the trajectory with a significant fate bias >1 or at least \code{trthr} of the random forest votes, respectively.

For simulateneous computation and plotting of the principal curve, see function \code{plotFateMap}.
}
\examples{

x <- intestine$x
y <- intestine$y
tar <- c(6,9,13)
fb <- fateBias(x,y,tar,z=NULL,minnr=5,minnrh=10,nbfactor=5,use.dist=FALSE,seed=NULL,nbtree=NULL)
dr <- compdr(x,z=NULL,m="cmd",k=2,lle.n=30,tsne.perplexity=30)
pr <- prcurve(y,fb,dr,k=2,m="cmd",trthr=0.25,start=NULL)

}
